/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.IntegerOperators;
import com.facebook.presto.type.VarcharOperators;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.function.BiFunction;
import org.apache.commons.math3.util.Precision;

abstract class AbstractTestNoisySfmAggregation {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    AbstractTestNoisySfmAggregation() {
    }

    protected abstract String getFunctionName();

    protected abstract long getCardinalityFromResult(Object var1);

    protected SfmSketch getSketchFromResult(Object result) {
        return SfmSketch.deserialize((Slice)Slices.wrappedBuffer((byte[])((SqlVarbinary)result).getBytes()));
    }

    protected static JavaAggregationFunctionImplementation getAggregator(String functionName, Type ... type) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(functionName, TypeSignatureProvider.fromTypes((Type[])type)));
    }

    protected boolean equalCardinalityWithAbsoluteError(Object actual, Object expected, double delta) {
        long actualCardinality = this.getCardinalityFromResult(actual);
        long expectedCardinality = this.getCardinalityFromResult(expected);
        return Precision.equals((double)actualCardinality, (double)expectedCardinality, (double)delta);
    }

    protected void assertFunction(Block valuesBlock, Type valueType, double epsilon, int numberOfBuckets, int precision, BiFunction<Object, Object, Boolean> assertion, Object expected) {
        AggregationTestUtils.assertAggregation(AbstractTestNoisySfmAggregation.getAggregator(this.getFunctionName(), new Type[]{valueType, DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}), assertion, null, new Page(new Block[]{valuesBlock, BlockAssertions.createDoubleRepeatBlock(epsilon, valuesBlock.getPositionCount()), BlockAssertions.createLongRepeatBlock(numberOfBuckets, valuesBlock.getPositionCount()), BlockAssertions.createLongRepeatBlock(precision, valuesBlock.getPositionCount())}), expected);
    }

    protected void assertFunction(Block valuesBlock, Type valueType, double epsilon, int numberOfBuckets, BiFunction<Object, Object, Boolean> assertion, Object expected) {
        AggregationTestUtils.assertAggregation(AbstractTestNoisySfmAggregation.getAggregator(this.getFunctionName(), new Type[]{valueType, DoubleType.DOUBLE, BigintType.BIGINT}), assertion, null, new Page(new Block[]{valuesBlock, BlockAssertions.createDoubleRepeatBlock(epsilon, valuesBlock.getPositionCount()), BlockAssertions.createLongRepeatBlock(numberOfBuckets, valuesBlock.getPositionCount())}), expected);
    }

    protected void assertFunction(Block valuesBlock, Type valueType, double epsilon, BiFunction<Object, Object, Boolean> assertion, Object expected) {
        AggregationTestUtils.assertAggregation(AbstractTestNoisySfmAggregation.getAggregator(this.getFunctionName(), new Type[]{valueType, DoubleType.DOUBLE}), assertion, null, new Page(new Block[]{valuesBlock, BlockAssertions.createDoubleRepeatBlock(epsilon, valuesBlock.getPositionCount())}), expected);
    }

    protected void assertCardinality(Block valuesBlock, Type valueType, double epsilon, int numberOfBuckets, int precision, Object expected, long delta) {
        this.assertFunction(valuesBlock, valueType, epsilon, numberOfBuckets, precision, (actualValue, expectedValue) -> this.equalCardinalityWithAbsoluteError(actualValue, expectedValue, delta), expected);
    }

    protected void assertCardinality(Block valuesBlock, Type valueType, double epsilon, int numberOfBuckets, Object expected, long delta) {
        this.assertFunction(valuesBlock, valueType, epsilon, numberOfBuckets, (actualValue, expectedValue) -> this.equalCardinalityWithAbsoluteError(actualValue, expectedValue, delta), expected);
    }

    protected void assertCardinality(Block valuesBlock, Type valueType, double epsilon, Object expected, long delta) {
        this.assertFunction(valuesBlock, valueType, epsilon, (actualValue, expectedValue) -> this.equalCardinalityWithAbsoluteError(actualValue, expectedValue, delta), expected);
    }

    protected SfmSketch createLongSketch(int numberOfBuckets, int precision, int start, int end) {
        SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision);
        for (int i = start; i < end; ++i) {
            sketch.addHash(IntegerOperators.xxHash64((long)i));
        }
        return sketch;
    }

    protected SfmSketch createDoubleSketch(int numberOfBuckets, int precision, int start, int end) {
        SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision);
        for (int i = start; i < end; ++i) {
            sketch.addHash(DoubleOperators.xxHash64((double)i));
        }
        return sketch;
    }

    protected SfmSketch createStringSketch(int numberOfBuckets, int precision, int start, int end) {
        SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision);
        for (int i = start; i < end; ++i) {
            sketch.addHash(VarcharOperators.xxHash64((Slice)Slices.utf8Slice((String)Long.toString(i))));
        }
        return sketch;
    }

    protected SqlVarbinary toSqlVarbinary(SfmSketch sketch) {
        return new SqlVarbinary(sketch.serialize().getBytes());
    }
}

