/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.AbstractTestNoisySfmAggregation;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.type.SfmSketchType;
import org.testng.annotations.Test;

public class TestMergeSfmSketchAggregation
extends AbstractTestNoisySfmAggregation {
    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected long getCardinalityFromResult(Object result) {
        return this.getSketchFromResult(result).cardinality();
    }

    private Block[] buildBlocks(SfmSketch ... sketches) {
        BlockBuilder builder = SfmSketchType.SFM_SKETCH.createBlockBuilder(null, 3);
        for (SfmSketch sketch : sketches) {
            SfmSketchType.SFM_SKETCH.writeSlice(builder, sketch.serialize());
        }
        return new Block[]{builder.build()};
    }

    private void assertMergedCardinality(SfmSketch[] indivdualSketches, SfmSketch mergedSketch, double delta) {
        AggregationTestUtils.assertAggregation(TestMergeSfmSketchAggregation.getAggregator(this.getFunctionName(), new Type[]{SfmSketchType.SFM_SKETCH}), (actualValue, expectedValue) -> this.equalCardinalityWithAbsoluteError(actualValue, expectedValue, delta), null, new Page(this.buildBlocks(indivdualSketches)), this.toSqlVarbinary(mergedSketch));
    }

    @Test
    public void testMergeOneNonPrivate() {
        SfmSketch sketch = this.createLongSketch(4096, 24, 1, 100000);
        this.assertMergedCardinality(new SfmSketch[]{sketch}, sketch, 0.0);
    }

    @Test
    public void testMergeOnePrivate() {
        SfmSketch sketch = this.createLongSketch(4096, 24, 1, 100000);
        sketch.enablePrivacy(4.0);
        this.assertMergedCardinality(new SfmSketch[]{sketch}, sketch, 0.0);
    }

    @Test
    public void testMergeManyNonPrivate() {
        SfmSketch sketch1 = this.createLongSketch(4096, 24, 1, 100000);
        SfmSketch sketch2 = this.createLongSketch(4096, 24, 50000, 200000);
        SfmSketch sketch3 = this.createLongSketch(4096, 24, 190000, 210000);
        SfmSketch mergedSketch = this.createLongSketch(4096, 24, 1, 210000);
        this.assertMergedCardinality(new SfmSketch[]{sketch1, sketch2, sketch3}, mergedSketch, 0.0);
    }

    @Test
    public void testMergeManyPrivate() {
        SfmSketch sketch1 = this.createLongSketch(4096, 24, 1, 100000);
        SfmSketch sketch2 = this.createLongSketch(4096, 24, 50000, 200000);
        SfmSketch sketch3 = this.createLongSketch(4096, 24, 190000, 210000);
        SfmSketch mergedSketch = this.createLongSketch(4096, 24, 1, 210000);
        sketch1.enablePrivacy(10.0);
        sketch2.enablePrivacy(11.0);
        sketch3.enablePrivacy(12.0);
        this.assertMergedCardinality(new SfmSketch[]{sketch1, sketch2, sketch3}, mergedSketch, 50000.0);
    }
}

