/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.NamedType;
import com.facebook.presto.common.type.P4HyperLogLogType;
import com.facebook.presto.common.type.QuantileDigestParametricType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TDigestParametricType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import com.facebook.presto.common.type.UuidType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.TestNoisyAggregationUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.IpAddressType;
import com.facebook.presto.type.IpPrefixType;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.RowParametricType;
import com.facebook.presto.type.khyperloglog.KHyperLogLogType;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNoisyCountGaussianRandomSeedAggregation
extends AbstractTestFunctions {
    private static final String FUNCTION_NAME = "noisy_count_gaussian";
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testNoisyCountGaussianDefinitions() {
        this.getFunction(new Type[]{TinyintType.TINYINT, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{SmallintType.SMALLINT, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{IntegerType.INTEGER, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{RealType.REAL, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{DecimalType.createDecimalType((int)38, (int)0), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{DecimalType.createDecimalType((int)18, (int)0), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{CharType.createCharType((long)1L), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{VarbinaryType.VARBINARY, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{JsonType.JSON, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{DateType.DATE, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{TimeType.TIME, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{TimestampType.TIMESTAMP, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{IntervalDayTimeType.INTERVAL_DAY_TIME, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{IntervalYearMonthType.INTERVAL_YEAR_MONTH, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{ArrayParametricType.ARRAY.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)DoubleType.DOUBLE))), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{MapParametricType.MAP.createType(FunctionAndTypeManager.createTestFunctionAndTypeManager(), (List)ImmutableList.of((Object)TypeParameter.of((Type)BigintType.BIGINT), (Object)TypeParameter.of((Type)DoubleType.DOUBLE))), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{RowParametricType.ROW.createType((List)ImmutableList.of((Object)TypeParameter.of((NamedType)new NamedType(Optional.of(new RowFieldName("x", false)), (Type)DoubleType.DOUBLE)))), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{IpAddressType.IPADDRESS, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{IpPrefixType.IPPREFIX, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{UuidType.UUID, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{HyperLogLogType.HYPER_LOG_LOG, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{P4HyperLogLogType.P4_HYPER_LOG_LOG, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{KHyperLogLogType.K_HYPER_LOG_LOG, DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{QuantileDigestParametricType.QDIGEST.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)DoubleType.DOUBLE))), DoubleType.DOUBLE, BigintType.BIGINT});
        this.getFunction(new Type[]{TDigestParametricType.TDIGEST.createType((List)ImmutableList.of((Object)TypeParameter.of((Type)DoubleType.DOUBLE))), DoubleType.DOUBLE, BigintType.BIGINT});
    }

    @Test
    public void testNoisyCountGaussianRandomSeedLongZeroNoiseScaleZeroRandomSeed() {
        JavaAggregationFunctionImplementation noisyCountGaussian = this.getFunction(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 1000;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        AggregationTestUtils.assertAggregation(noisyCountGaussian, TestNoisyAggregationUtils.equalLongAssertion, "Test noisy_count_gaussian(long, noiseScale, randomSeed) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createLongsBlock(values), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(0L, numRows)}), numRows);
    }

    @Test
    public void testNoisyCountGaussianRandomSeedLongSomeNoiseScaleFixedRandomSeed() {
        JavaAggregationFunctionImplementation noisyCountGaussian = this.getFunction(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 1000;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        AggregationTestUtils.assertAggregation(noisyCountGaussian, TestNoisyAggregationUtils.equalLongAssertion, "Test noisy_count_gaussian(long, noiseScale, randomSeed) with noiseScale=12 which there is some noise, and a fixed random seed", new Page(new Block[]{BlockAssertions.createLongsBlock(values), BlockAssertions.createRLEBlock(12.0, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), 1010);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Noise scale must be >= 0")
    public void testNoisyCountGaussianRandomSeedLongInvalidNoiseScale() {
        JavaAggregationFunctionImplementation noisyCountGaussian = this.getFunction(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 1000;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        AggregationTestUtils.assertAggregation(noisyCountGaussian, TestNoisyAggregationUtils.equalLongAssertion, "Test noisy_count_gaussian(long, noiseScale, randomSeed) with noiseScale < 0 which we expect an error", new Page(new Block[]{BlockAssertions.createLongsBlock(values), BlockAssertions.createRLEBlock(-123.0, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), numRows);
    }

    @Test
    public void testNoisyCountGaussianRandomSeedLongRandomNoiseWithinSomeStd() {
        JavaAggregationFunctionImplementation noisyCountGaussian = this.getFunction(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 1000;
        List<Long> values = TestNoisyAggregationUtils.createTestValues(numRows, false, 1L, true);
        AggregationTestUtils.assertAggregation(noisyCountGaussian, TestNoisyAggregationUtils.withinSomeStdAssertion, "Test noisy_count_gaussian(long, noiseScale) with noiseScale=DEFAULT_TEST_STANDARD_DEVIATION and expect result is within some std from mean", new Page(new Block[]{BlockAssertions.createLongsBlock(values), BlockAssertions.createRLEBlock(1.0, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), numRows);
    }

    @Test
    public void testNoisyCountGaussianRandomSeedNoInputRowsWithoutGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "varchar"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("bigint");
        String query = "SELECT noisy_count_gaussian(" + columnName + ", 0, 1) + 1 FROM " + data + " WHERE false";
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)1);
        Assert.assertNull((Object)actualRows.get(0).getField(0));
    }

    @Test
    public void testNoisyCountGaussianRandomSeedNoInputRowsWithGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("bigint", "varchar"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("bigint");
        String query = "SELECT noisy_count_gaussian(" + columnName + ", 0, 1) + 1 FROM " + data + " WHERE false GROUP BY " + columnName;
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)0);
    }

    private List<MaterializedRow> runQuery(String query) {
        LocalQueryRunner runner = new LocalQueryRunner(this.session);
        MaterializedResult actualResults = runner.execute(query).toTestTypes();
        return actualResults.getMaterializedRows();
    }

    private JavaAggregationFunctionImplementation getFunction(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(FUNCTION_NAME, TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

