/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.TestNoisyAggregationUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNoisyCountIfGaussianAggregation
extends AbstractTestFunctions {
    private static final String FUNCTION_NAME = "noisy_count_if_gaussian";
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    @Test
    public void testNoisyCountIfGaussianDefinitions() {
        this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE});
        this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE, BigintType.BIGINT});
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testNoisyCountIfGaussianInvalidNoiseScale() {
        JavaAggregationFunctionImplementation noisyCountIfGaussian = this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE});
        int numRows = 10;
        List<Boolean> values = TestNoisyAggregationUtils.createTestValues(numRows, false, true, false);
        double expected = TestNoisyAggregationUtils.countTrue(values);
        AggregationTestUtils.assertAggregation(noisyCountIfGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_count_if_gaussian(boolean, noiseScale) with noiseScale < 0 which means errors", new Page(new Block[]{BlockAssertions.createBooleansBlock(values), BlockAssertions.createRLEBlock(-123.0, numRows)}), expected);
    }

    @Test
    public void testNoisyCountIfGaussianZeroNoiseScale() {
        JavaAggregationFunctionImplementation noisyCountIfGaussian = this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE});
        int numRows = 10;
        List<Boolean> values = TestNoisyAggregationUtils.createTestValues(numRows, false, true, false);
        double expected = TestNoisyAggregationUtils.countTrue(values);
        AggregationTestUtils.assertAggregation(noisyCountIfGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_count_if_gaussian(boolean, noiseScale) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createBooleansBlock(values), BlockAssertions.createRLEBlock(0.0, numRows)}), expected);
    }

    @Test
    public void testNoisyCountIfGaussianZeroNoiseScaleWithNull() {
        JavaAggregationFunctionImplementation noisyCountIfGaussian = this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE});
        int numRows = 10;
        List<Boolean> values = TestNoisyAggregationUtils.createTestValues(numRows, true, true, false);
        double expected = TestNoisyAggregationUtils.countTrue(values);
        AggregationTestUtils.assertAggregation(noisyCountIfGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_count_if_gaussian(boolean, noiseScale) with noiseScale=0 and 1 null row which means no noise", new Page(new Block[]{BlockAssertions.createBooleansBlock(values), BlockAssertions.createRLEBlock(0.0, numRows)}), expected);
    }

    @Test
    public void testNoisyCountIfGaussianSomeNoiseScaleWithinSomeStd() {
        JavaAggregationFunctionImplementation noisyCountIfGaussian = this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE});
        int numRows = 1000;
        List<Boolean> values = TestNoisyAggregationUtils.createTestValues(numRows, true, true, false);
        double expected = TestNoisyAggregationUtils.countTrue(values);
        AggregationTestUtils.assertAggregation(noisyCountIfGaussian, TestNoisyAggregationUtils.withinSomeStdAssertion, "Test noisy_count_if_gaussian(boolean, noiseScale) within some std from mean", new Page(new Block[]{BlockAssertions.createBooleansBlock(values), BlockAssertions.createRLEBlock(1.0, numRows)}), expected);
    }

    @Test
    public void testNoisyCountIfGaussianNoiseScaleVsNormalCountIf() {
        int numRows = 10;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("boolean", "double"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("boolean");
        String query1 = String.format("SELECT COUNT_IF(%s) FROM %s", columnName, data);
        String query2 = String.format("SELECT %s(%s, %f) FROM %s", FUNCTION_NAME, columnName, 0.0, data);
        List<MaterializedRow> actualRows = this.runQuery(query1);
        double result1 = Double.parseDouble(actualRows.get(0).getField(0).toString());
        actualRows = this.runQuery(query2);
        double result2 = Double.parseDouble(actualRows.get(0).getField(0).toString());
        Assert.assertEquals((double)result2, (double)result1);
    }

    @Test
    public void testNoisyCountIfGaussianZeroNoiseScaleZeroRandomSeed() {
        JavaAggregationFunctionImplementation noisyCountIfGaussian = this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Boolean> values = TestNoisyAggregationUtils.createTestValues(numRows, true, true, false);
        double expected = TestNoisyAggregationUtils.countTrue(values);
        AggregationTestUtils.assertAggregation(noisyCountIfGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_count_if_gaussian(boolean, noiseScale, randomSeed) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createBooleansBlock(values), BlockAssertions.createRLEBlock(0.0, numRows), BlockAssertions.createRLEBlock(0L, numRows)}), expected);
    }

    @Test
    public void testNoisyCountIfGaussianSomeNoiseScaleFixedRandomSeed() {
        JavaAggregationFunctionImplementation noisyCountIfGaussian = this.getFunction(new Type[]{BooleanType.BOOLEAN, DoubleType.DOUBLE, BigintType.BIGINT});
        int numRows = 10;
        List<Boolean> values = TestNoisyAggregationUtils.createTestValues(numRows, true, true, false);
        double expected = TestNoisyAggregationUtils.countTrue(values) + 10.0;
        AggregationTestUtils.assertAggregation(noisyCountIfGaussian, TestNoisyAggregationUtils.equalDoubleAssertion, "Test noisy_count_if_gaussian(boolean, noiseScale, randomSeed) with noiseScale=0 which means no noise", new Page(new Block[]{BlockAssertions.createBooleansBlock(values), BlockAssertions.createRLEBlock(12.0, numRows), BlockAssertions.createRLEBlock(10L, numRows)}), expected);
    }

    @Test
    public void testNoisyCountIfGaussianNoInputRowsWithoutGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("boolean", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("boolean");
        String query = "SELECT noisy_count_if_gaussian(" + columnName + ", 0) + 1 FROM " + data + " WHERE false";
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)1);
        Assert.assertNull((Object)actualRows.get(0).getField(0));
    }

    @Test
    public void testNoisyCountIfGaussianNoInputRowsWithGroupBy() {
        int numRows = 100;
        String data = TestNoisyAggregationUtils.buildData(numRows, true, Arrays.asList("boolean", "double", "real", "decimal"));
        String columnName = TestNoisyAggregationUtils.buildColumnName("boolean");
        String query = "SELECT noisy_count_if_gaussian(" + columnName + ", 0) + 1 FROM " + data + " WHERE false GROUP BY " + columnName;
        List<MaterializedRow> actualRows = this.runQuery(query);
        Assert.assertEquals((int)actualRows.size(), (int)0);
    }

    private List<MaterializedRow> runQuery(String query) {
        LocalQueryRunner runner = new LocalQueryRunner(this.session);
        MaterializedResult actualResults = runner.execute(query).toTestTypes();
        return actualResults.getMaterializedRows();
    }

    private JavaAggregationFunctionImplementation getFunction(Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(FUNCTION_NAME, TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

