/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchStateFactory;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.RandomizationStrategy;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.TestingSeededRandomizationStrategy;
import io.airlift.slice.Slice;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSfmSketchStateFactory {
    private final SfmSketchStateFactory factory = new SfmSketchStateFactory();

    @Test
    public void testCreateSingleStateEmpty() {
        SfmSketchState state = this.factory.createSingleState();
        Assert.assertNull((Object)state.getSketch());
        Assert.assertEquals((long)state.getEstimatedSize(), (long)ClassLayout.parseClass(SfmSketchStateFactory.SingleSfmSketchState.class).instanceSize());
    }

    @Test
    public void testCreateSingleStatePresent() {
        SfmSketchState state = this.factory.createSingleState();
        long emptySize = state.getEstimatedSize();
        SfmSketch sketch = SfmSketch.create((int)16, (int)16);
        state.setSketch(sketch);
        Assert.assertEquals((Object)sketch, (Object)state.getSketch());
        Assert.assertEquals((long)(state.getEstimatedSize() - emptySize), (long)sketch.getRetainedSizeInBytes());
    }

    @Test
    public void testCreateGroupedStateEmpty() {
        SfmSketchState state = this.factory.createGroupedState();
        Assert.assertNull((Object)state.getSketch());
        int instanceSize = 40;
        long bigObjectSize = new ObjectBigArray().sizeOf();
        Assert.assertTrue((state.getEstimatedSize() >= (long)instanceSize + bigObjectSize ? 1 : 0) != 0, (String)String.format("Estimated memory size was %d", state.getEstimatedSize()));
    }

    @Test
    public void testCreateGroupedStatePresent() {
        SfmSketchState state = this.factory.createGroupedState();
        Assert.assertTrue((boolean)(state instanceof SfmSketchStateFactory.GroupedSfmSketchState));
        SfmSketchStateFactory.GroupedSfmSketchState groupedState = (SfmSketchStateFactory.GroupedSfmSketchState)state;
        groupedState.setGroupId(1L);
        Assert.assertNull((Object)state.getSketch());
        SfmSketch sketch1 = SfmSketch.create((int)16, (int)16);
        groupedState.setSketch(sketch1);
        Assert.assertEquals((Object)state.getSketch(), (Object)sketch1);
        groupedState.setGroupId(2L);
        Assert.assertNull((Object)state.getSketch());
        SfmSketch sketch2 = SfmSketch.create((int)32, (int)32);
        groupedState.setSketch(sketch2);
        Assert.assertEquals((Object)state.getSketch(), (Object)sketch2);
        groupedState.setGroupId(1L);
        Assert.assertNotNull((Object)state.getSketch());
    }

    @Test
    public void testGroupedMemoryAccounting() {
        SfmSketchState state = this.factory.createGroupedState();
        long emptySize = state.getEstimatedSize();
        SfmSketch sketch1 = SfmSketch.create((int)1024, (int)16);
        sketch1.add(1L);
        sketch1 = SfmSketch.deserialize((Slice)sketch1.serialize());
        SfmSketch sketch2 = SfmSketch.create((int)1024, (int)16);
        sketch2.add(0L);
        sketch2 = SfmSketch.deserialize((Slice)sketch2.serialize());
        SfmSketch sketch3 = SfmSketch.create((int)1024, (int)16);
        sketch3.enablePrivacy(0.1, (RandomizationStrategy)new TestingSeededRandomizationStrategy(1L));
        sketch3 = SfmSketch.deserialize((Slice)sketch3.serialize());
        state.setSketch(sketch1);
        long memoryIncrease = state.getEstimatedSize() - emptySize;
        Assert.assertEquals((long)memoryIncrease, (long)state.getSketch().getRetainedSizeInBytes());
        state.mergeSketch(sketch2);
        memoryIncrease = state.getEstimatedSize() - emptySize - memoryIncrease;
        Assert.assertEquals((long)memoryIncrease, (long)0L);
        Assert.assertEquals((long)(state.getEstimatedSize() - emptySize), (long)state.getSketch().getRetainedSizeInBytes());
        state.mergeSketch(sketch3);
        memoryIncrease = state.getEstimatedSize() - emptySize - memoryIncrease;
        Assert.assertTrue((memoryIncrease >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)(state.getEstimatedSize() - emptySize), (long)state.getSketch().getRetainedSizeInBytes());
    }
}

