/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchStateFactory;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.type.SfmSketchType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSfmSketchStateSerializer {
    @Test
    public void testSerializeDeserialize() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(SfmSketchState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(SfmSketchState.class);
        SfmSketchState state = (SfmSketchState)factory.createSingleState();
        SfmSketch sketch = SfmSketch.create((int)16, (int)16);
        state.setSketch(sketch);
        state.setEpsilon(0.1);
        BlockBuilder builder = SfmSketchType.SFM_SKETCH.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        state.setSketch(null);
        serializer.deserialize(block, 0, (Object)state);
        Assert.assertNotNull((Object)state.getSketch());
        Assert.assertEquals((double)state.getEpsilon(), (double)0.1);
    }

    @Test
    public void testSerializeDeserializeGrouped() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(SfmSketchState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(SfmSketchState.class);
        SfmSketchStateFactory.GroupedSfmSketchState state = (SfmSketchStateFactory.GroupedSfmSketchState)factory.createGroupedState();
        double epsilon1 = 0.1;
        double epsilon2 = 0.2;
        SfmSketch sketch1 = SfmSketch.create((int)16, (int)16);
        SfmSketch sketch2 = SfmSketch.create((int)32, (int)16);
        state.setGroupId(1L);
        state.setSketch(sketch1);
        state.setEpsilon(epsilon1);
        state.setGroupId(2L);
        state.setSketch(sketch2);
        state.setEpsilon(epsilon2);
        state.setGroupId(1L);
        BlockBuilder builder = SfmSketchType.SFM_SKETCH.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        state.setEpsilon(0.99);
        serializer.deserialize(block, 0, (Object)state);
        state.getSketch().cardinality();
        Assert.assertNotNull((Object)state.getSketch());
        Assert.assertEquals((double)state.getEpsilon(), (double)epsilon1);
        state.setGroupId(2L);
        Assert.assertNotNull((Object)state.getSketch());
        Assert.assertEquals((double)state.getEpsilon(), (double)epsilon2);
        state.setGroupId(3L);
        Assert.assertNull((Object)state.getSketch());
    }
}

