/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation.sketch;

import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.Bitmap;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.RandomizationStrategy;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.TestingDeterministicRandomizationStrategy;
import io.airlift.slice.SizeOf;
import java.util.BitSet;
import java.util.Random;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBitmap {
    private TestBitmap() {
    }

    @Test
    public static void testRoundTrip() {
        byte[] bytes = TestBitmap.randomBytes(100);
        Assert.assertEquals((byte[])Bitmap.fromBytes((int)800, (byte[])bytes).toBytes(), (byte[])bytes);
    }

    @Test
    public static void testSetBit() {
        Bitmap bitmap = new Bitmap(24);
        bitmap.setBit(0, true);
        bitmap.setBit(1, true);
        bitmap.setBit(8, true);
        bitmap.setBit(10, true);
        bitmap.setBit(16, true);
        bitmap.setBit(18, true);
        bitmap.setBit(20, true);
        bitmap.setBit(22, true);
        byte[] bytes = bitmap.toBytes();
        Assert.assertEquals((int)bytes[0], (int)3);
        Assert.assertEquals((int)bytes[1], (int)5);
        Assert.assertEquals((int)bytes[2], (int)85);
        for (int i = 10; i < 24; ++i) {
            bitmap.setBit(i, false);
        }
        bytes = bitmap.toBytes();
        Assert.assertEquals((int)bytes.length, (int)2);
        Assert.assertEquals((int)bytes[0], (int)3);
        Assert.assertEquals((int)bytes[1], (int)1);
    }

    @Test
    public static void testGetBit() {
        Bitmap bitmap = new Bitmap(4096);
        for (int i = 0; i < 4096; ++i) {
            bitmap.setBit(i, true);
            Assert.assertTrue((boolean)bitmap.getBit(i));
            bitmap.setBit(i, false);
            Assert.assertFalse((boolean)bitmap.getBit(i));
        }
    }

    @Test
    public void testGetBitCount() {
        int length = 1024;
        Bitmap bitmap = new Bitmap(length);
        Assert.assertEquals((int)bitmap.getBitCount(), (int)0);
        for (int i = 0; i < length; ++i) {
            bitmap.setBit(i, true);
            Assert.assertEquals((int)bitmap.getBitCount(), (int)(i + 1));
        }
    }

    @Test
    public static void testFlipBit() {
        Bitmap bitmap = new Bitmap(4096);
        for (int i = 0; i < 4096; ++i) {
            bitmap.flipBit(i);
            Assert.assertTrue((boolean)bitmap.getBit(i));
            bitmap.flipBit(i);
            Assert.assertFalse((boolean)bitmap.getBit(i));
            bitmap.flipBit(i);
            Assert.assertTrue((boolean)bitmap.getBit(i));
        }
    }

    @Test
    public static void testByteLength() {
        for (int length : new int[]{8, 800}) {
            Bitmap bitmap = new Bitmap(length);
            for (int i = 0; i < length; ++i) {
                bitmap.setBit(i, true);
                Assert.assertEquals((int)bitmap.byteLength(), (int)bitmap.toBytes().length);
            }
        }
    }

    @Test
    public static void testLength() {
        for (int i = 1; i <= 10; ++i) {
            Bitmap bitmap = new Bitmap(i * 8);
            Assert.assertEquals((int)bitmap.length(), (int)(i * 8));
        }
    }

    @Test
    public static void testRandomFlips() {
        int i;
        Bitmap bitmap = new Bitmap(16);
        TestingDeterministicRandomizationStrategy randomizationStrategy = new TestingDeterministicRandomizationStrategy();
        bitmap.flipBit(0, 0.75, (RandomizationStrategy)randomizationStrategy);
        Assert.assertTrue((boolean)bitmap.getBit(0));
        bitmap.flipBit(0, 0.75, (RandomizationStrategy)randomizationStrategy);
        Assert.assertFalse((boolean)bitmap.getBit(0));
        bitmap.flipBit(0, 0.25, (RandomizationStrategy)randomizationStrategy);
        Assert.assertFalse((boolean)bitmap.getBit(0));
        bitmap.flipAll(0.75, (RandomizationStrategy)randomizationStrategy);
        for (i = 0; i < 16; ++i) {
            Assert.assertTrue((boolean)bitmap.getBit(i));
        }
        bitmap.flipAll(0.25, (RandomizationStrategy)randomizationStrategy);
        for (i = 0; i < 16; ++i) {
            Assert.assertTrue((boolean)bitmap.getBit(i));
        }
    }

    @Test
    public static void testClone() {
        Bitmap bitmapA = Bitmap.fromBytes((int)800, (byte[])TestBitmap.randomBytes(100));
        Bitmap bitmapB = bitmapA.clone();
        for (int i = 0; i < 800; ++i) {
            Assert.assertEquals((boolean)bitmapA.getBit(i), (boolean)bitmapB.getBit(i));
        }
        bitmapA.flipBit(0);
        Assert.assertEquals((boolean)bitmapA.getBit(0), (!bitmapB.getBit(0) ? 1 : 0) != 0);
    }

    @Test
    public static void testOr() {
        Bitmap bitmapA = Bitmap.fromBytes((int)800, (byte[])TestBitmap.randomBytes(100));
        Bitmap bitmapB = Bitmap.fromBytes((int)800, (byte[])TestBitmap.randomBytes(100));
        Bitmap bitmapC = bitmapA.clone();
        bitmapC.or(bitmapB);
        for (int i = 0; i < 800; ++i) {
            Assert.assertEquals((boolean)bitmapC.getBit(i), (boolean)(bitmapA.getBit(i) | bitmapB.getBit(i)));
        }
    }

    @Test
    public static void testXor() {
        Bitmap bitmapA = Bitmap.fromBytes((int)800, (byte[])TestBitmap.randomBytes(100));
        Bitmap bitmapB = Bitmap.fromBytes((int)800, (byte[])TestBitmap.randomBytes(100));
        Bitmap bitmapC = bitmapA.clone();
        bitmapC.xor(bitmapB);
        for (int i = 0; i < 800; ++i) {
            Assert.assertEquals((boolean)bitmapC.getBit(i), (boolean)(bitmapA.getBit(i) ^ bitmapB.getBit(i)));
        }
    }

    @Test
    public static void testRetainedSize() {
        int instanceSizes = ClassLayout.parseClass(Bitmap.class).instanceSize() + ClassLayout.parseClass(BitSet.class).instanceSize();
        Bitmap bitmap = new Bitmap(1024);
        Assert.assertEquals((long)bitmap.getRetainedSizeInBytes(), (long)((long)instanceSizes + SizeOf.sizeOfLongArray((int)16)));
    }

    private static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        Random random = new Random();
        random.nextBytes(bytes);
        return bytes;
    }
}

