/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayDistinct {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 2;
    private static final int NUM_TYPES = 1;
    private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);

    @Benchmark
    @OperationsPerInvocation(value=200000)
    public List<Optional<Page>> arrayDistinct(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayDistinct().arrayDistinct(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkArrayDistinct.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @ScalarFunction
    @SqlType(value="array(varchar)")
    public static Block oldArrayDistinct(@SqlType(value="array(varchar)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        TypedSet typedSet = new TypedSet((Type)VarcharType.VARCHAR, array.getPositionCount(), "old_array_distinct");
        BlockBuilder distinctElementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            VarcharType.VARCHAR.appendTo(array, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }

    static {
        Verify.verify((1 == TYPES.size() ? 1 : 0) != 0);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"array_distinct", "old_array_distinct"})
        private String name = "array_distinct";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
            metadata.registerBuiltInFunctions(FunctionExtractor.extractFunctions(BenchmarkArrayDistinct.class));
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[TYPES.size()];
            for (int i = 0; i < TYPES.size(); ++i) {
                Type elementType = (Type)TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                FunctionHandle functionHandle = functionAndTypeManager.lookupFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType}));
                projectionsBuilder.add((Object)new CallExpression(this.name, functionHandle, (Type)arrayType, (List)ImmutableList.of((Object)Expressions.field((int)i, (Type)arrayType))));
                blocks[i] = BenchmarkData.createChannel(100000, 2, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (arrayType.getElementType().getJavaType() == Long.TYPE) {
                        arrayType.getElementType().writeLong(entryBuilder, ThreadLocalRandom.current().nextLong());
                        continue;
                    }
                    if (arrayType.getElementType().equals(VarcharType.VARCHAR)) {
                        arrayType.getElementType().writeSlice(entryBuilder, Slices.utf8Slice((String)"test_string"));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

