/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArraySetFunctions {
    private static final int POSITIONS = 1000;

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public List<Optional<Page>> arrayFunction(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION.getSqlFunctionProperties(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArraySetFunctions().arrayFunction(data);
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArraySetFunctions().arrayFunction(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkArraySetFunctions.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"array_except", "array_intersect", "array_union"})
        private String name = "array_union";
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String type = "BIGINT";
        @Param(value={"10", "100", "1000"})
        private int arraySize = 1000;
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            BigintType elementType;
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    break;
                }
                case "BOOLEAN": {
                    elementType = BooleanType.BOOLEAN;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            ArrayType arrayType = new ArrayType((Type)elementType);
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
            FunctionHandle functionHandle = functionAndTypeManager.lookupFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, arrayType}));
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(this.name, functionHandle, (Type)arrayType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.field((int)1, (Type)arrayType))));
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(TestingConnectorSession.SESSION.getSqlFunctionProperties(), Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{BenchmarkData.createChannel(1000, this.arraySize, (Type)elementType), BenchmarkData.createChannel(1000, this.arraySize, (Type)elementType)});
        }

        private static Block createChannel(int positionCount, int arraySize, Type elementType) {
            ArrayType arrayType = new ArrayType(elementType);
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (elementType.getJavaType() == Long.TYPE) {
                        elementType.writeLong(entryBuilder, ThreadLocalRandom.current().nextLong() % (long)arraySize);
                        continue;
                    }
                    if (elementType.getJavaType() == Double.TYPE) {
                        elementType.writeDouble(entryBuilder, ThreadLocalRandom.current().nextDouble() % (double)arraySize);
                        continue;
                    }
                    if (elementType.getJavaType() == Boolean.TYPE) {
                        elementType.writeBoolean(entryBuilder, ThreadLocalRandom.current().nextBoolean());
                        continue;
                    }
                    if (elementType.equals(VarcharType.VARCHAR)) {
                        elementType.writeSlice(entryBuilder, Slices.utf8Slice((String)Long.toString(ThreadLocalRandom.current().nextLong() % (long)arraySize)));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

