/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlParameters;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;

public final class CustomFunctions {
    private CustomFunctions() {
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long customAdd(@SqlType(value="bigint") long x, @SqlType(value="bigint") long y) {
        return x + y;
    }

    @ScalarFunction(value="custom_is_null", calledOnNullInput=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean customIsNullVarchar(@SqlNullable @SqlType(value="varchar(x)") Slice slice) {
        return slice == null;
    }

    @ScalarFunction(value="custom_is_null", calledOnNullInput=true)
    @SqlType(value="boolean")
    public static boolean customIsNullBigint(@SqlNullable @SqlType(value="bigint") Long value) {
        return value == null;
    }

    @SqlInvokedScalarFunction(value="custom_square", deterministic=true, calledOnNullInput=false)
    @Description(value="Custom SQL to test NULLIF in Functions")
    @SqlParameters(value={@SqlParameter(name="x", type="integer"), @SqlParameter(name="y", type="integer")})
    @SqlType(value="integer")
    public static String customSquare() {
        return "RETURN IF(NULLIF(x, y) IS NOT NULL, x * x, y * y)";
    }
}

