/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestArrayCumulativeSumFunction
extends AbstractTestFunctions {
    @Test
    public void testIntArray() {
        this.assertFunction("array_cum_sum(ARRAY [cast(5 as INTEGER), 6, 0])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5, (Object)11, (Object)11));
        this.assertFunction("array_cum_sum(ARRAY [cast(5 as INTEGER), 6, null, null, 2, 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(5, 11, null, null, null, null));
        this.assertFunction("array_cum_sum(ARRAY [cast(null as INTEGER), 6, 2, 3, 2, 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, null, null, null, null, null));
        this.assertFunction("array_cum_sum(CAST(ARRAY[] AS array(integer)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_cum_sum(CAST(NULL AS array(integer)))", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunctionThrowsIncorrectly("array_cum_sum(ARRAY [cast(2147483647 as integer), 2147483647, 2147483647])", PrestoException.class, "integer addition overflow:.*");
    }

    @Test
    public void testBigIntArray() {
        this.assertFunction("array_cum_sum(ARRAY [cast(5 as bigint), 6, 0])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L, (Object)11L, (Object)11L));
        this.assertFunction("array_cum_sum(ARRAY [cast(5 as bigint), 6, null, null, 2, 1])", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(5L, 11L, null, null, null, null));
        this.assertFunction("array_cum_sum(ARRAY [cast(null as bigint), 6, 2, 3, 2, 1])", (Type)new ArrayType((Type)BigintType.BIGINT), Arrays.asList(null, null, null, null, null, null));
        this.assertFunction("array_cum_sum(CAST(ARRAY[] AS array(bigint)))", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of());
        this.assertFunction("array_cum_sum(CAST(NULL AS array(bigint)))", (Type)new ArrayType((Type)BigintType.BIGINT), null);
        this.assertFunction("array_cum_sum(ARRAY [cast(2147483647 as bigint), 2147483647, 2147483647])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)Integer.MAX_VALUE, (Object)0xFFFFFFFEL, (Object)6442450941L));
    }

    @Test
    public void testRealArray() {
        this.assertFunctionFloatArrayWithError("array_cum_sum(ARRAY [cast(5.1 as real), 6.1, 0.5])", (Type)new ArrayType((Type)RealType.REAL), (List<Float>)ImmutableList.of((Object)Float.valueOf(5.1f), (Object)Float.valueOf(11.2f), (Object)Float.valueOf(11.7f)), 1.0E-5f);
        this.assertFunction("array_cum_sum(ARRAY [cast(5.1 as real), 6, null, null, 2, 1.2])", (Type)new ArrayType((Type)RealType.REAL), Arrays.asList(Float.valueOf(5.1f), Float.valueOf(11.1f), null, null, null, null));
        this.assertFunction("array_cum_sum(ARRAY [cast(null as real), 6.2, 2, 3, 2, 1])", (Type)new ArrayType((Type)RealType.REAL), Arrays.asList(null, null, null, null, null, null));
        this.assertFunction("array_cum_sum(CAST(ARRAY[] AS array(real)))", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of());
        this.assertFunction("array_cum_sum(CAST(NULL AS array(real)))", (Type)new ArrayType((Type)RealType.REAL), null);
    }

    @Test
    public void testDoubleArray() {
        this.assertFunctionDoubleArrayWithError("array_cum_sum(ARRAY [cast(5.1 as double), 6.1, 0.5])", (Type)new ArrayType((Type)DoubleType.DOUBLE), (List<Double>)ImmutableList.of((Object)5.1, (Object)11.2, (Object)11.7), 1.0E-5);
        this.assertFunction("array_cum_sum(ARRAY [cast(5.1 as double), 6, null, null, 2, 1.2])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(5.1, 11.1, null, null, null, null));
        this.assertFunction("array_cum_sum(ARRAY [cast(null as double), 6.2, 2, 3, 2, 1])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(null, null, null, null, null, null));
        this.assertFunction("array_cum_sum(CAST(ARRAY[] AS array(double)))", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of());
        this.assertFunction("array_cum_sum(CAST(NULL AS array(double)))", (Type)new ArrayType((Type)DoubleType.DOUBLE), null);
    }

    @Test
    public void testVarcharArray() {
        this.assertFunctionThrowsIncorrectly("array_cum_sum(ARRAY [cast(5.1 as varchar), '6.1', '0.5'])", OperatorNotFoundException.class, ".*cannot be applied to.*");
        this.assertFunctionThrowsIncorrectly("array_cum_sum(ARRAY [cast(null as varchar), '6.1', '0.5'])", OperatorNotFoundException.class, ".*cannot be applied to.*");
    }

    @Test
    public void testDecimalArray() {
        this.assertFunction("array_cum_sum(cast(ARRAY[5.1, 6.1, 0.5] as array(decimal(2, 1))))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableList.of((Object)SqlDecimal.of((long)51L, (int)2, (int)1), (Object)SqlDecimal.of((long)112L, (int)2, (int)1), (Object)SqlDecimal.of((long)117L, (int)2, (int)1)));
        this.assertFunction("array_cum_sum(cast(ARRAY[5.1, 6, null, null, 2, 1.2] as array(decimal(2, 1))))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), Arrays.asList(SqlDecimal.of((long)51L, (int)2, (int)1), SqlDecimal.of((long)111L, (int)2, (int)1), null, null, null, null));
        this.assertFunction("array_cum_sum(cast(ARRAY[null, 6, 2, 3, 2, 1.2] as array(decimal(2, 1))))", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), Arrays.asList(null, null, null, null, null, null));
    }
}

