/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestArrayIntersectFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("array_intersect(ARRAY[1, 5, 3], ARRAY[3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("array_intersect(ARRAY[CAST(1 as BIGINT), 5, 3], ARRAY[5])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L));
        this.assertFunction("array_intersect(ARRAY[CAST('x' as VARCHAR), 'y', 'z'], ARRAY['x', 'y'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"x", (Object)"y"));
        this.assertFunction("array_intersect(ARRAY[true, false, null], ARRAY[true, null])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true, null));
        this.assertFunction("array_intersect(ARRAY[1.1E0, 5.4E0, 3.9E0], ARRAY[5, 5.4E0])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)5.4));
    }

    @Test
    public void testEmpty() {
        this.assertFunction("array_intersect(ARRAY[], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("array_intersect(ARRAY[], ARRAY[1, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_intersect(ARRAY[CAST('abc' as VARCHAR)], ARRAY[])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("array_intersect(ARRAY[NULL], NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_intersect(NULL, NULL)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_intersect(NULL, ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("array_intersect(ARRAY[NULL], ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(new Integer[]{null}));
        this.assertFunction("array_intersect(ARRAY[], ARRAY[NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
        this.assertFunction("array_intersect(ARRAY[NULL], ARRAY[])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
    }

    @Test
    public void testDuplicates() {
        this.assertFunction("array_intersect(ARRAY[1, 5, 3, 5, 1], ARRAY[3, 3, 5])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)5, (Object)3));
        this.assertFunction("array_intersect(ARRAY[CAST(1 as BIGINT), 5, 5, 3, 3, 3, 1], ARRAY[3, 5])", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)5L, (Object)3L));
        this.assertFunction("array_intersect(ARRAY[CAST('x' as VARCHAR), 'x', 'y', 'z'], ARRAY['x', 'y', 'x'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"x", (Object)"y"));
        this.assertFunction("array_intersect(ARRAY[true, false, null, true, false, null], ARRAY[true, true, true])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), Arrays.asList(true));
    }

    @Test
    public void testSQLFunctions() {
        this.assertFunction("array_intersect(ARRAY[ARRAY[1, 3, 5], ARRAY[2, 3, 5], ARRAY[3, 3, 3, 6]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3));
        this.assertFunction("array_intersect(ARRAY[ARRAY[], ARRAY[1, 2, 3]])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_intersect(ARRAY[ARRAY[1, 2, 3], null])", (Type)new ArrayType((Type)IntegerType.INTEGER), null);
        this.assertFunction("array_intersect(ARRAY[ARRAY[DOUBLE'1.1', DOUBLE'2.2', DOUBLE'3.3'], ARRAY[DOUBLE'1.1', DOUBLE'3.4'], ARRAY[DOUBLE'1.0', DOUBLE'1.1', DOUBLE'1.2']])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.1));
        this.assertFunction("array_intersect(ARRAY[ARRAY[ARRAY[1], ARRAY[2]], ARRAY[ARRAY[2], ARRAY[3]]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)2)));
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"x", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"y", (Type)DoubleType.DOUBLE)));
        String t = rowType.toString();
        this.assertFunction("array_intersect(ARRAY[ARRAY[CAST((1.0, 2.0) AS " + t + "), CAST((2.0, 3.0) AS " + t + ")], ARRAY[CAST((0.0, 1.0) AS " + t + "), CAST((1.0, 2.0) AS " + t + ")]])", (Type)new ArrayType((Type)rowType), ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0)));
    }
}

