/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import org.testng.annotations.Test;

public class TestArrayNormalizeFunction
extends AbstractTestFunctions {
    @Test
    public void test0Norm() {
        this.assertFunction("array_normalize(ARRAY[1.0E0, 2.0E0, 3.3E0], 0.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.3));
        this.assertFunction("array_normalize(ARRAY[REAL '1.0', REAL '2.0', REAL '3.3'], REAL '0.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.3f)));
        this.assertFunction("array_normalize(ARRAY[-1.0E0, 2.0E0, 3.3E0], 0.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)-1.0, (Object)2.0, (Object)3.3));
        this.assertFunction("array_normalize(ARRAY[REAL '-1.0', REAL '2.0', REAL '3.3'], REAL '0.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.3f)));
    }

    @Test
    public void test1Norm() {
        this.assertFunction("array_normalize(ARRAY[1.0E0, 2.0E0, 3.0E0], 1.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.16666666666666666, (Object)0.3333333333333333, (Object)0.5));
        this.assertFunction("array_normalize(ARRAY[REAL '1.0', REAL '2.0', REAL '3.0'], REAL '1.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(0.16666667f), (Object)Float.valueOf(0.33333334f), (Object)Float.valueOf(0.5f)));
        this.assertFunction("array_normalize(ARRAY[-1.0E0, 2.0E0, 3.0E0], 1.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)-0.16666666666666666, (Object)0.3333333333333333, (Object)0.5));
        this.assertFunction("array_normalize(ARRAY[REAL '-1.0', REAL '2.0', REAL '3.0'], REAL '1.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(-0.16666667f), (Object)Float.valueOf(0.33333334f), (Object)Float.valueOf(0.5f)));
    }

    @Test
    public void test2Norm() {
        this.assertFunction("array_normalize(ARRAY[4.0E0, 3.0E0], 2.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.8, (Object)0.6));
        this.assertFunction("array_normalize(ARRAY[REAL '4.0', REAL '3.0'], REAL '2.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.6f)));
        this.assertFunction("array_normalize(ARRAY[-4.0E0, 3.0E0], 2.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)-0.8, (Object)0.6));
        this.assertFunction("array_normalize(ARRAY[REAL '-4.0', REAL '3.0'], REAL '2.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(-0.8f), (Object)Float.valueOf(0.6f)));
    }

    @Test
    public void testNulls() {
        this.assertFunction("array_normalize(null, 2.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), null);
        this.assertFunction("array_normalize(ARRAY[4.0E0, 3.0E0], null)", (Type)new ArrayType((Type)DoubleType.DOUBLE), null);
        this.assertFunction("array_normalize(ARRAY[4.0E0, null], 2.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), null);
        this.assertFunction("array_normalize(ARRAY[REAL '4.0', REAL '3.0'], null)", (Type)new ArrayType((Type)RealType.REAL), null);
    }

    @Test
    public void testArrayOfZeros() {
        this.assertFunction("array_normalize(ARRAY[0.0E0, 0.0E0], 1.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.0, (Object)0.0));
        this.assertFunction("array_normalize(ARRAY[REAL '0.0', REAL '0.0'], REAL '1.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
        this.assertFunction("array_normalize(ARRAY[0.0E0, 0.0E0], 2.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)0.0, (Object)0.0));
        this.assertFunction("array_normalize(ARRAY[REAL '0.0', REAL '0.0'], REAL '2.0')", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
    }

    @Test
    public void testUnsupportedType() {
        this.assertInvalidFunction("array_normalize(ARRAY[1, 2, 3], 1)", StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, "Unsupported array element type for array_normalize function: integer");
        this.assertInvalidFunction("array_normalize(ARRAY['a', 'b', 'c'], 'd')", StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, "Unsupported type parameters.*");
    }

    @Test
    public void testNegativeP() {
        this.assertInvalidFunction("array_normalize(ARRAY[1.0E0, 2.0E0, 3.3E0], -1.0E0)", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_normalize only supports non-negative p:.*");
        this.assertInvalidFunction("array_normalize(ARRAY[REAL '1.0', REAL '2.0', REAL '3.3'], REAL '-1.0')", StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_normalize only supports non-negative p:.*");
    }
}

