/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestArrayTrimFunction
extends AbstractTestFunctions {
    @Test
    public void testTrimArray() {
        this.assertFunction("trim_array(ARRAY[1, 2, 3, 4], 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        this.assertFunction("trim_array(ARRAY[1, 2, 3, 4], 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertFunction("trim_array(ARRAY[1, 2, 3, 4], 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("trim_array(ARRAY[1, 2, 3, 4], 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("trim_array(ARRAY[1, 2, 3, 4], 4)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("trim_array(ARRAY['a', 'b', 'c', 'd'], 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("trim_array(ARRAY['a', 'b', null, 'd'], 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), Arrays.asList("a", "b", null));
        this.assertFunction("trim_array(ARRAY[ARRAY[1, 2, 3], ARRAY[4, 5, 6]], 1)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3)));
        this.assertInvalidFunction("trim_array(ARRAY[1, 2, 3, 4], 5)", "size must not exceed array cardinality 4: 5");
        this.assertInvalidFunction("trim_array(ARRAY[1, 2, 3, 4], -1)", "size must not be negative: -1");
    }
}

