/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.testng.annotations.Test;

public class TestMapFilterFunction
extends AbstractTestFunctions {
    @Test
    public void testRetainedSizeBounded() {
        this.assertCachedInstanceHasBoundedRetainedSize("map_filter(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, 2, NULL, 4]), (k, v) -> v IS NOT NULL)");
    }

    @Test
    public void testEmpty() {
        this.assertFunction("map_filter(map(ARRAY[], ARRAY[]), (k, v) -> true)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("map_filter(map(ARRAY[], ARRAY[]), (k, v) -> false)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("map_filter(map(ARRAY[], ARRAY[]), (k, v) -> CAST (NULL AS BOOLEAN))", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("map_filter(CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR)), (k, v) -> true)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), ImmutableMap.of());
    }

    @Test
    public void testNull() {
        HashMap<Integer, Object> oneToNullMap = new HashMap<Integer, Object>();
        oneToNullMap.put(1, null);
        this.assertFunction("map_filter(map(ARRAY[1], ARRAY [NULL]), (k, v) -> v IS NULL)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), oneToNullMap);
        this.assertFunction("map_filter(map(ARRAY[1], ARRAY [NULL]), (k, v) -> v IS NOT NULL)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("map_filter(map(ARRAY[1], ARRAY [CAST (NULL AS INTEGER)]), (k, v) -> v IS NULL)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), oneToNullMap);
        HashMap<Integer, Object> sequenceToNullMap = new HashMap<Integer, Object>();
        sequenceToNullMap.put(1, null);
        sequenceToNullMap.put(2, null);
        sequenceToNullMap.put(3, null);
        this.assertFunction("map_filter(map(ARRAY[1, 2, 3], ARRAY [NULL, NULL, NULL]), (k, v) -> v IS NULL)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), sequenceToNullMap);
        this.assertFunction("map_filter(map(ARRAY[1, 2, 3], ARRAY [NULL, NULL, NULL]), (k, v) -> v IS NOT NULL)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
    }

    @Test
    public void testBasic() {
        this.assertFunction("map_filter(map(ARRAY [5, 6, 7, 8], ARRAY [5, 6, 6, 5]), (x, y) -> x <= 6 OR y = 5)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)5, (Object)5, (Object)6, (Object)6, (Object)8, (Object)5));
        this.assertFunction("map_filter(map(ARRAY [5 + RANDOM(1), 6, 7, 8], ARRAY [5, 6, 6, 5]), (x, y) -> x <= 6 OR y = 5)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)5, (Object)5, (Object)6, (Object)6, (Object)8, (Object)5));
        this.assertFunction("map_filter(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, 2, NULL, 4]), (k, v) -> v IS NOT NULL)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"d", (Object)4));
        this.assertFunction("map_filter(map(ARRAY ['a', 'b', 'c'], ARRAY [TRUE, FALSE, NULL]), (k, v) -> v)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)"a", (Object)true));
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("map_filter(map(ARRAY [25, 26, 27], ARRAY [25, 26, 27]), (k, v) -> k = 25 OR v = 27)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)25, (Object)25, (Object)27, (Object)27));
        this.assertFunction("map_filter(map(ARRAY [25, 26, 27], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k = 25 OR v = 27.5E0)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25, (Object)25.5, (Object)27, (Object)27.5));
        this.assertFunction("map_filter(map(ARRAY [25, 26, 27], ARRAY [false, null, true]), (k, v) -> k = 25 OR v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)25, (Object)false, (Object)27, (Object)true));
        this.assertFunction("map_filter(map(ARRAY [25, 26, 27], ARRAY ['abc', 'def', 'xyz']), (k, v) -> k = 25 OR v = 'xyz')", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)25, (Object)"abc", (Object)27, (Object)"xyz"));
        this.assertFunction("map_filter(map(ARRAY [25, 26, 27], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'c'], ARRAY ['a', 'b', 'c']]), (k, v) -> k = 25 OR cardinality(v) = 3)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)25, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)27, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        this.assertFunction("map_filter(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [25, 26, 27]), (k, v) -> k = 25.5E0 OR v = 27)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)25.5, (Object)25, (Object)27.5, (Object)27));
        this.assertFunction("map_filter(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k = 25.5E0 OR v = 27.5E0)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)25.5, (Object)27.5, (Object)27.5));
        this.assertFunction("map_filter(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [false, null, true]), (k, v) -> k = 25.5E0 OR v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)25.5, (Object)false, (Object)27.5, (Object)true));
        this.assertFunction("map_filter(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY ['abc', 'def', 'xyz']), (k, v) -> k = 25.5E0 OR v = 'xyz')", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)25.5, (Object)"abc", (Object)27.5, (Object)"xyz"));
        this.assertFunction("map_filter(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'c'], ARRAY ['a', 'b', 'c']]), (k, v) -> k = 25.5E0 OR cardinality(v) = 3)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)25.5, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)27.5, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        this.assertFunction("map_filter(map(ARRAY [true, false], ARRAY [25, 26]), (k, v) -> k AND v = 25)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)true, (Object)25));
        this.assertFunction("map_filter(map(ARRAY [false, true], ARRAY [25.5E0, 26.5E0]), (k, v) -> k OR v > 100)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)true, (Object)26.5));
        HashMap<Boolean, Object> falseToNullMap = new HashMap<Boolean, Object>();
        falseToNullMap.put(false, null);
        this.assertFunction("map_filter(map(ARRAY [true, false], ARRAY [false, null]), (k, v) -> NOT k OR v)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), falseToNullMap);
        this.assertFunction("map_filter(map(ARRAY [false, true], ARRAY ['abc', 'def']), (k, v) -> NOT k AND v = 'abc')", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)false, (Object)"abc"));
        this.assertFunction("map_filter(map(ARRAY [true, false], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'b', 'c']]), (k, v) -> k OR cardinality(v) = 3)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)true, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)false, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        this.assertFunction("map_filter(map(ARRAY ['s0', 's1', 's2'], ARRAY [25, 26, 27]), (k, v) -> k = 's0' OR v = 27)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"s0", (Object)25, (Object)"s2", (Object)27));
        this.assertFunction("map_filter(map(ARRAY ['s0', 's1', 's2'], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k = 's0' OR v = 27.5E0)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)"s0", (Object)25.5, (Object)"s2", (Object)27.5));
        this.assertFunction("map_filter(map(ARRAY ['s0', 's1', 's2'], ARRAY [false, null, true]), (k, v) -> k = 's0' OR v)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)"s0", (Object)false, (Object)"s2", (Object)true));
        this.assertFunction("map_filter(map(ARRAY ['s0', 's1', 's2'], ARRAY ['abc', 'def', 'xyz']), (k, v) -> k = 's0' OR v = 'xyz')", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)"s0", (Object)"abc", (Object)"s2", (Object)"xyz"));
        this.assertFunction("map_filter(map(ARRAY ['s0', 's1', 's2'], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'c'], ARRAY ['a', 'b', 'c']]), (k, v) -> k = 's0' OR cardinality(v) = 3)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)"s0", (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)"s2", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        this.assertFunction("map_filter(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4], ARRAY []], ARRAY [25, 26, 27]), (k, v) -> k = ARRAY [1, 2] OR v = 27)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)25, (Object)ImmutableList.of(), (Object)27));
        this.assertFunction("map_filter(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4], ARRAY []], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k = ARRAY [1, 2] OR v = 27.5E0)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)25.5, (Object)ImmutableList.of(), (Object)27.5));
        this.assertFunction("map_filter(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4], ARRAY []], ARRAY [false, null, true]), (k, v) -> k = ARRAY [1, 2] OR v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)false, (Object)ImmutableList.of(), (Object)true));
        this.assertFunction("map_filter(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4], ARRAY []], ARRAY ['abc', 'def', 'xyz']), (k, v) -> k = ARRAY [1, 2] OR v = 'xyz')", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)"abc", (Object)ImmutableList.of(), (Object)"xyz"));
        this.assertFunction("map_filter(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4], ARRAY []], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'b', 'c'], ARRAY ['a', 'c']]), (k, v) -> cardinality(k) = 0 OR cardinality(v) = 3)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"a", (Object)"c")));
    }
}

