/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.testng.annotations.Test;

public class TestMapTransformKeyFunction
extends AbstractTestFunctions {
    @Test
    public void testRetainedSizeBounded() {
        this.assertCachedInstanceHasBoundedRetainedSize("transform_keys(map(ARRAY [1, 2, 3, 4], ARRAY [10, 20, 30, 40]), (k, v) -> k + v)");
    }

    @Test
    public void testEmpty() {
        this.assertFunction("transform_keys(map(ARRAY[], ARRAY[]), (k, v) -> NULL)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_keys(map(ARRAY[], ARRAY[]), (k, v) -> k)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_keys(map(ARRAY[], ARRAY[]), (k, v) -> v)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_keys(map(ARRAY[], ARRAY[]), (k, v) -> 0)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_keys(map(ARRAY[], ARRAY[]), (k, v) -> true)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_keys(map(ARRAY[], ARRAY[]), (k, v) -> 'key')", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_keys(CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR)), (k, v) -> k + CAST(v as BIGINT))", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), ImmutableMap.of());
        this.assertFunction("transform_keys(CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR)), (k, v) -> v)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of());
    }

    @Test
    public void testNullKey() {
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY ['a', 'b', 'c']), (k, v) -> NULL)", "map key cannot be null");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY ['a', 'b', NULL]), (k, v) -> v)", "map key cannot be null");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY [1, 2, NULL]), (k, v) -> k + v)", "map key cannot be null");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY ['1', '2', 'Invalid']), (k, v) -> TRY_CAST(v as BIGINT))", "map key cannot be null");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY [1.0E0, 1.4E0, 1.7E0]), (k, v) -> element_at(map(ARRAY[1, 2], ARRAY['one', 'two']), k))", "map key cannot be null");
    }

    @Test
    public void testDuplicateKeys() {
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3, 4], ARRAY ['a', 'b', 'c', 'd']), (k, v) -> k % 3)", "Duplicate keys (1) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY ['a', 'b', 'c']), (k, v) -> k % 2 = 0)", "Duplicate keys (false) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1.5E0, 2.5E0, 3.5E0], ARRAY ['a', 'b', 'c']), (k, v) -> k - floor(k))", "Duplicate keys (0.5) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2, 3, 4], ARRAY ['a', 'b', 'c', 'b']), (k, v) -> v)", "Duplicate keys (b) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY['abc1', 'cba2', 'abc3'], ARRAY [1, 2, 3]), (k, v) -> substr(k, 1, 3))", "Duplicate keys (abc) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY[ARRAY [1], ARRAY [2]], ARRAY [2, 1]), (k, v) -> array_sort(k || v))", "Duplicate keys ([1, 2]) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2], ARRAY [null, null]), (k, v) -> DATE '2001-08-22')", "Duplicate keys (2001-08-22) are not allowed");
        this.assertInvalidFunction("transform_keys(map(ARRAY[1, 2], ARRAY [null, null]), (k, v) -> TIMESTAMP '2001-08-22 03:04:05.321')", "Duplicate keys (2001-08-22 03:04:05.321) are not allowed");
    }

    @Test
    public void testBasic() {
        this.assertFunction("transform_keys(map(ARRAY [1, 2, 3, 4], ARRAY [10, 20, 30, 40]), (k, v) -> k + v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)11, (Object)10, (Object)22, (Object)20, (Object)33, (Object)30, (Object)44, (Object)40));
        this.assertFunction("transform_keys(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, 2, 3, 4]), (k, v) -> v * v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)1, (Object)4, (Object)2, (Object)9, (Object)3, (Object)16, (Object)4));
        this.assertFunction("transform_keys(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, 2, 3, 4]), (k, v) -> k || CAST(v as VARCHAR))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a1", (Object)1, (Object)"b2", (Object)2, (Object)"c3", (Object)3, (Object)"d4", (Object)4));
        this.assertFunction("transform_keys(map(ARRAY[1, 2, 3], ARRAY [1.0E0, 1.4E0, 1.7E0]), (k, v) -> map(ARRAY[1, 2, 3], ARRAY['one', 'two', 'three'])[k])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)5), (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)"one", (Object)1.0, (Object)"two", (Object)1.4, (Object)"three", (Object)1.7));
        HashMap<String, Integer> expectedStringIntMap = new HashMap<String, Integer>();
        expectedStringIntMap.put("a1", 1);
        expectedStringIntMap.put("b0", null);
        expectedStringIntMap.put("c3", 3);
        expectedStringIntMap.put("d4", 4);
        this.assertFunction("transform_keys(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, NULL, 3, 4]), (k, v) -> k || COALESCE(CAST(v as VARCHAR), '0'))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), expectedStringIntMap);
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("transform_keys(map(ARRAY [25, 26, 27], ARRAY [25, 26, 27]), (k, v) -> k + v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)50, (Object)25, (Object)52, (Object)26, (Object)54, (Object)27));
        this.assertFunction("transform_keys(map(ARRAY [25, 26, 27], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k + v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)50.5, (Object)25.5, (Object)52.5, (Object)26.5, (Object)54.5, (Object)27.5));
        this.assertFunction("transform_keys(map(ARRAY [25, 26], ARRAY [false, true]), (k, v) -> k % 2 = 0 OR v)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        this.assertFunction("transform_keys(map(ARRAY [25, 26, 27], ARRAY ['abc', 'def', 'xyz']), (k, v) -> to_base(k, 16) || substr(v, 1, 1))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)"19a", (Object)"abc", (Object)"1ad", (Object)"def", (Object)"1bx", (Object)"xyz"));
        this.assertFunction("transform_keys(map(ARRAY [25, 26], ARRAY [ARRAY ['a'], ARRAY ['b']]), (k, v) -> ARRAY [CAST(k AS VARCHAR)] || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)ImmutableList.of((Object)"25", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"26", (Object)"b"), (Object)ImmutableList.of((Object)"b")));
        this.assertFunction("transform_keys(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [25, 26, 27]), (k, v) -> CAST(k * 2 AS BIGINT) + v)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)76L, (Object)25, (Object)79L, (Object)26, (Object)82L, (Object)27));
        this.assertFunction("transform_keys(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k + v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)51.0, (Object)25.5, (Object)53.0, (Object)26.5, (Object)55.0, (Object)27.5));
        this.assertFunction("transform_keys(map(ARRAY [25.2E0, 26.2E0], ARRAY [false, true]), (k, v) -> CAST(k AS BIGINT) % 2 = 0 OR v)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        this.assertFunction("transform_keys(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY ['abc', 'def', 'xyz']), (k, v) -> CAST(k AS VARCHAR) || substr(v, 1, 1))", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)"25.5a", (Object)"abc", (Object)"26.5d", (Object)"def", (Object)"27.5x", (Object)"xyz"));
        this.assertFunction("transform_keys(map(ARRAY [25.5E0, 26.5E0], ARRAY [ARRAY ['a'], ARRAY ['b']]), (k, v) -> ARRAY [CAST(k AS VARCHAR)] || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)ImmutableList.of((Object)"25.5", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"26.5", (Object)"b"), (Object)ImmutableList.of((Object)"b")));
        this.assertFunction("transform_keys(map(ARRAY [true, false], ARRAY [25, 26]), (k, v) -> if(k, 2 * v, 3 * v))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)50, (Object)25, (Object)78, (Object)26));
        this.assertFunction("transform_keys(map(ARRAY [false, true], ARRAY [25.5E0, 26.5E0]), (k, v) -> if(k, 2 * v, 3 * v))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)76.5, (Object)25.5, (Object)53.0, (Object)26.5));
        HashMap<Boolean, Boolean> expectedBoolBoolMap = new HashMap<Boolean, Boolean>();
        expectedBoolBoolMap.put(false, true);
        expectedBoolBoolMap.put(true, null);
        this.assertFunction("transform_keys(map(ARRAY [true, false], ARRAY [true, NULL]), (k, v) -> if(k, NOT v, v IS NULL))", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), expectedBoolBoolMap);
        this.assertFunction("transform_keys(map(ARRAY [false, true], ARRAY ['abc', 'def']), (k, v) -> if(k, substr(v, 1, 2), substr(v, 1, 1)))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)"a", (Object)"abc", (Object)"de", (Object)"def"));
        this.assertFunction("transform_keys(map(ARRAY [true, false], ARRAY [ARRAY ['a', 'b'], ARRAY ['x', 'y']]), (k, v) -> if(k, reverse(v), v))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)ImmutableList.of((Object)"b", (Object)"a"), (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"x", (Object)"y"), (Object)ImmutableList.of((Object)"x", (Object)"y")));
        this.assertFunction("transform_keys(map(ARRAY ['a', 'ab', 'abc'], ARRAY [25, 26, 27]), (k, v) -> length(k) + v)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)26L, (Object)25, (Object)28L, (Object)26, (Object)30L, (Object)27));
        this.assertFunction("transform_keys(map(ARRAY ['a', 'ab', 'abc'], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> length(k) + v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)26.5, (Object)25.5, (Object)28.5, (Object)26.5, (Object)30.5, (Object)27.5));
        this.assertFunction("transform_keys(map(ARRAY ['a', 'b'], ARRAY [false, true]), (k, v) -> k = 'b' OR v)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        this.assertFunction("transform_keys(map(ARRAY ['a', 'x'], ARRAY ['bc', 'yz']), (k, v) -> k || v)", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.createVarcharType((int)2)), ImmutableMap.of((Object)"abc", (Object)"bc", (Object)"xyz", (Object)"yz"));
        this.assertFunction("transform_keys(map(ARRAY ['x', 'y'], ARRAY [ARRAY ['a'], ARRAY ['b']]), (k, v) -> k || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)ImmutableList.of((Object)"x", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"y", (Object)"b"), (Object)ImmutableList.of((Object)"b")));
        this.assertFunction("transform_keys(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [25, 26]), (k, v) -> reduce(k, 0, (s, x) -> s + x, s -> s) + v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)28, (Object)25, (Object)33, (Object)26));
        this.assertFunction("transform_keys(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [25.5E0, 26.5E0]), (k, v) -> reduce(k, 0, (s, x) -> s + x, s -> s) + v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)28.5, (Object)25.5, (Object)33.5, (Object)26.5));
        this.assertFunction("transform_keys(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [false, true]), (k, v) -> contains(k, 3) AND v)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        this.assertFunction("transform_keys(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY ['abc', 'xyz']), (k, v) -> transform(k, x -> CAST(x AS VARCHAR)) || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)VarcharType.createVarcharType((int)3)), ImmutableMap.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"abc"), (Object)"abc", (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"xyz"), (Object)"xyz"));
        this.assertFunction("transform_keys(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [ARRAY ['a'], ARRAY ['a', 'b']]), (k, v) -> transform(k, x -> CAST(x AS VARCHAR)) || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableMap.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"a"), (Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"a", (Object)"b")));
    }
}

