/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Union;
import org.testng.annotations.Test;

public class TestThetaSketchFunctions
extends AbstractTestFunctions {
    @Test
    public void testNullSketch() {
        this.functionAssertions.assertFunction("sketch_theta_estimate(CAST(NULL as VARBINARY))", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testEstimateEmptySketch() {
        Union union = Union.builder().buildUnion();
        this.functionAssertions.assertFunction(String.format("sketch_theta_estimate(CAST(X'%s' as VARBINARY))", TestThetaSketchFunctions.toVarbinarySql(union.getResult().toByteArray())), (Type)DoubleType.DOUBLE, 0.0);
    }

    @Test
    public void testEstimateSingleValue() {
        Union union = Union.builder().buildUnion();
        union.update(1L);
        this.functionAssertions.assertFunction(String.format("sketch_theta_estimate(CAST(X'%s' as VARBINARY))", TestThetaSketchFunctions.toVarbinarySql(union.getResult().toByteArray())), (Type)DoubleType.DOUBLE, 1.0);
    }

    @Test
    public void testEstimateManyValues() {
        Union union = Union.builder().buildUnion();
        int size = 100;
        for (int i = 0; i < size; ++i) {
            union.update((long)i);
        }
        this.functionAssertions.assertFunction(String.format("sketch_theta_estimate(CAST(X'%s' as VARBINARY))", TestThetaSketchFunctions.toVarbinarySql(union.getResult().toByteArray())), (Type)DoubleType.DOUBLE, size);
    }

    @Test
    public void testSummaryNull() {
        this.functionAssertions.assertFunction("sketch_theta_summary(CAST(NULL as VARBINARY)).estimate", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testSummarySingle() {
        Union union = Union.builder().buildUnion();
        union.update(1L);
        CompactSketch compactSketch = union.getResult();
        this.summaryMatches(compactSketch, union.getResult().toByteArray());
    }

    @Test
    public void testSummaryMany() {
        Union union = Union.builder().buildUnion();
        int size = 100;
        for (int i = 0; i < size; ++i) {
            union.update((long)i);
        }
        this.summaryMatches(union.getResult(), union.getResult().toByteArray());
    }

    private void summaryMatches(CompactSketch expected, byte[] input) {
        this.functionAssertions.assertFunction(String.format("sketch_theta_summary(CAST(X'%s' as VARBINARY)).estimate", TestThetaSketchFunctions.toVarbinarySql(input)), (Type)DoubleType.DOUBLE, expected.getEstimate());
        this.functionAssertions.assertFunction(String.format("sketch_theta_summary(CAST(X'%s' as VARBINARY)).theta", TestThetaSketchFunctions.toVarbinarySql(input)), (Type)DoubleType.DOUBLE, expected.getTheta());
        this.functionAssertions.assertFunction(String.format("sketch_theta_summary(CAST(X'%s' as VARBINARY)).upper_bound_std", TestThetaSketchFunctions.toVarbinarySql(input)), (Type)DoubleType.DOUBLE, expected.getUpperBound(1));
        this.functionAssertions.assertFunction(String.format("sketch_theta_summary(CAST(X'%s' as VARBINARY)).lower_bound_std", TestThetaSketchFunctions.toVarbinarySql(input)), (Type)DoubleType.DOUBLE, expected.getLowerBound(1));
        this.functionAssertions.assertFunction(String.format("sketch_theta_summary(CAST(X'%s' as VARBINARY)).retained_entries", TestThetaSketchFunctions.toVarbinarySql(input)), (Type)IntegerType.INTEGER, expected.getRetainedEntries());
    }

    private static String toVarbinarySql(byte[] data) {
        return new SqlVarbinary(data).toString().replaceAll("\\s+", " ");
    }
}

