/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.annotations.Test;

public class TestZipFunction
extends AbstractTestFunctions {
    @Test
    public void testSameLength() {
        this.assertFunction("zip(ARRAY[1, 2], ARRAY['a', 'b'])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)}), TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(2, "b")));
        this.assertFunction("zip(ARRAY[1, 2], ARRAY['a', CAST('b' AS VARCHAR)])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}), TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(2, "b")));
        this.assertFunction("zip(ARRAY[1, 2, 3, 4], ARRAY['a', 'b', 'c', 'd'])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)}), TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(2, "b"), TestZipFunction.list(3, "c"), TestZipFunction.list(4, "d")));
        this.assertFunction("zip(ARRAY[1, 2], ARRAY['a', 'b'],  ARRAY['c', 'd'])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1), VarcharType.createVarcharType((int)1)}), TestZipFunction.list(TestZipFunction.list(1, "a", "c"), TestZipFunction.list(2, "b", "d")));
        this.assertFunction("zip(ARRAY[1, 2], ARRAY['a', 'b'],  ARRAY['c', 'd'], ARRAY['e', 'f'])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1), VarcharType.createVarcharType((int)1), VarcharType.createVarcharType((int)1)}), TestZipFunction.list(TestZipFunction.list(1, "a", "c", "e"), TestZipFunction.list(2, "b", "d", "f")));
        this.assertFunction("zip(ARRAY[], ARRAY[])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN}), TestZipFunction.list(new Object[0]));
        this.assertFunction("zip(ARRAY[], ARRAY[], ARRAY[])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN}), TestZipFunction.list(new Object[0]));
        this.assertFunction("zip(ARRAY[], ARRAY[], ARRAY[], ARRAY[])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN}), TestZipFunction.list(new Object[0]));
        this.assertFunction("zip(ARRAY[NULL], ARRAY[NULL])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN}), TestZipFunction.list(TestZipFunction.list(null, null)));
        this.assertFunction("zip(ARRAY[ARRAY[1, 1], ARRAY[1, 2]], ARRAY[ARRAY[2, 1], ARRAY[2, 2]])", TestZipFunction.zipReturnType(new Type[]{new ArrayType((Type)IntegerType.INTEGER), new ArrayType((Type)IntegerType.INTEGER)}), TestZipFunction.list(TestZipFunction.list(TestZipFunction.list(1, 1), TestZipFunction.list(2, 1)), TestZipFunction.list(TestZipFunction.list(1, 2), TestZipFunction.list(2, 2))));
    }

    @Test
    public void testDifferentLength() {
        this.assertFunction("zip(ARRAY[1], ARRAY['a', 'b'])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)}), TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(null, "b")));
        this.assertFunction("zip(ARRAY[NULL, 2], ARRAY['a'])", TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)}), TestZipFunction.list(TestZipFunction.list(null, "a"), TestZipFunction.list(2, null)));
        this.assertFunction("zip(ARRAY[], ARRAY[1], ARRAY[1, 2], ARRAY[1, 2, 3])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, IntegerType.INTEGER, IntegerType.INTEGER, IntegerType.INTEGER}), TestZipFunction.list(TestZipFunction.list(null, 1, 1, 1), TestZipFunction.list(null, null, 2, 2), TestZipFunction.list(null, null, null, 3)));
        this.assertFunction("zip(ARRAY[], ARRAY[NULL], ARRAY[NULL, NULL])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN}), TestZipFunction.list(TestZipFunction.list(null, null, null), TestZipFunction.list(null, null, null)));
    }

    @Test
    public void testWithNull() {
        this.assertFunction("zip(CAST(NULL AS ARRAY(UNKNOWN)), ARRAY[],  ARRAY[1])", TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, IntegerType.INTEGER}), null);
    }

    @Test
    public void testAllArities() {
        for (int arity = 2; arity <= 7; ++arity) {
            String[] arguments = (String[])IntStream.rangeClosed(1, arity).mapToObj(index -> "ARRAY[" + index + "]").toArray(String[]::new);
            Type[] types = (Type[])IntStream.rangeClosed(1, arity).mapToObj(index -> IntegerType.INTEGER).toArray(Type[]::new);
            this.assertFunction(String.format("zip(%s)", String.join((CharSequence)", ", TestZipFunction.list(arguments))), TestZipFunction.zipReturnType(types), TestZipFunction.list(IntStream.rangeClosed(1, arity).boxed().collect(Collectors.toList())));
        }
    }

    private static Type zipReturnType(Type ... types) {
        return new ArrayType((Type)RowType.anonymous(TestZipFunction.list(types)));
    }

    @SafeVarargs
    private static <T> List<T> list(T ... a) {
        return Arrays.asList(a);
    }
}

