/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testng.annotations.Test;

public class TestArraySqlFunctions
extends AbstractTestFunctions {
    @Test
    public void testArraySum() {
        this.assertFunction("array_sum(array[BIGINT '1', BIGINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[INTEGER '1', INTEGER '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[SMALLINT '1', SMALLINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[TINYINT '1', TINYINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[BIGINT '1', INTEGER '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[INTEGER '1', SMALLINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("array_sum(array[SMALLINT '1', TINYINT '2'])", (Type)BigintType.BIGINT, 3L);
        this.assertFunctionWithError("array_sum(array[DOUBLE '-2.0', DOUBLE '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[DOUBLE '-2.0', REAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[DOUBLE '-2.0', DECIMAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[REAL '-2.0', DECIMAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[BIGINT '-2', DOUBLE '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[INTEGER '-2', REAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[SMALLINT '-2', DECIMAL '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunctionWithError("array_sum(array[TINYINT '-2', DOUBLE '5.3'])", (Type)DoubleType.DOUBLE, 3.3);
        this.assertFunction("array_sum(null)", (Type)BigintType.BIGINT, null);
        this.assertFunction("array_sum(array[])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("array_sum(array[NULL])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("array_sum(array[NULL, NULL, NULL])", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("array_sum(array[3, NULL, 5])", (Type)BigintType.BIGINT, 8L);
        this.assertFunctionWithError("array_sum(array[NULL, double '1.2', double '2.3', NULL, -3])", (Type)DoubleType.DOUBLE, 0.5);
    }

    @Test
    public void testArrayAverage() {
        this.assertFunctionWithError("array_average(array[1, 2])", (Type)DoubleType.DOUBLE, 1.5);
        this.assertFunctionWithError("array_average(array[1, bigint '2', smallint '3', tinyint '4', 5.0])", (Type)DoubleType.DOUBLE, 3.0);
        this.assertFunctionWithError("array_average(array[1, null, 2, null])", (Type)DoubleType.DOUBLE, 1.5);
        this.assertFunctionWithError("array_average(array[null, null, 1])", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("array_average(array[null])", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("array_average(array[null, null])", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("array_average(null)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testArrayFrequencyBigint() {
        this.assertFunction("array_frequency(cast(null as array(bigint)))", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), null);
        this.assertFunction("array_frequency(cast(array[] as array(bigint)))", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("array_frequency(array[cast(null as bigint), cast(null as bigint), cast(null as bigint)])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("array_frequency(array[cast(null as bigint), bigint '1'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)1));
        this.assertFunction("array_frequency(array[cast(null as bigint), bigint '1', bigint '3', cast(null as bigint), bigint '1', bigint '3', cast(null as bigint)])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)2, (Object)3L, (Object)2));
        this.assertFunction("array_frequency(array[bigint '1', bigint '1', bigint '2', bigint '2', bigint '3', bigint '1', bigint '3', bigint '2'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)3, (Object)2L, (Object)3, (Object)3L, (Object)2));
        this.assertFunction("array_frequency(array[bigint '45'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)45L, (Object)1));
        this.assertFunction("array_frequency(array[bigint '-45'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)-45L, (Object)1));
        this.assertFunction("array_frequency(array[bigint '1', bigint '3', bigint '1', bigint '3'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)2, (Object)3L, (Object)2));
        this.assertFunction("array_frequency(array[bigint '3', bigint '1', bigint '3',bigint '1'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)2, (Object)3L, (Object)2));
        this.assertFunction("array_frequency(array[bigint '4',bigint '3',bigint '3',bigint '2',bigint '2',bigint '2',bigint '1',bigint '1',bigint '1',bigint '1'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)4, (Object)2L, (Object)3, (Object)3L, (Object)2, (Object)4L, (Object)1));
        this.assertFunction("array_frequency(array[bigint '3', bigint '3', bigint '2', bigint '2', bigint '5', bigint '5', bigint '1', bigint '1'])", (Type)BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1L, (Object)2, (Object)2L, (Object)2, (Object)3L, (Object)2, (Object)5L, (Object)2));
    }

    @Test
    public void testArrayFrequencyVarchar() {
        this.assertFunction("array_frequency(cast(null as array(varchar)))", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), null);
        this.assertFunction("array_frequency(cast(array[] as array(varchar)))", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("array_frequency(array[cast(null as varchar), cast(null as varchar), cast(null as varchar)])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("array_frequency(array[varchar 'z', cast(null as varchar)])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"z", (Object)1));
        this.assertFunction("array_frequency(array[varchar 'a', cast(null as varchar), varchar 'b', cast(null as varchar), cast(null as varchar) ])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)1));
        this.assertFunction("array_frequency(array[varchar 'a', varchar 'b', varchar 'a', varchar 'a', varchar 'a'])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a", (Object)4, (Object)"b", (Object)1));
        this.assertFunction("array_frequency(array[varchar 'a', varchar 'b', varchar 'a', varchar 'b', varchar 'c'])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a", (Object)2, (Object)"b", (Object)2, (Object)"c", (Object)1));
        this.assertFunction("array_frequency(array[varchar 'y', varchar 'p'])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"p", (Object)1, (Object)"y", (Object)1));
        this.assertFunction("array_frequency(array[varchar 'a', varchar 'a', varchar 'p'])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"p", (Object)1, (Object)"a", (Object)2));
        this.assertFunction("array_frequency(array[varchar 'z'])", (Type)BlockAssertions.createMapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"z", (Object)1));
    }

    @Test
    public void testArrayFrequencyComplexTypes() {
        this.assertFunction("array_frequency(cast(null as array(array(varchar))))", (Type)BlockAssertions.createMapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)IntegerType.INTEGER), null);
        this.assertFunction("array_frequency(cast(array[] as array(array(varchar))))", (Type)BlockAssertions.createMapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("array_frequency(array[cast(null as array(varchar)), cast(null as array(varchar)), cast(null as array(varchar))])", (Type)BlockAssertions.createMapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("array_frequency(array[array[varchar 'z'], array[varchar 'z']])", (Type)BlockAssertions.createMapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)IntegerType.INTEGER), ImmutableMap.of(Collections.singletonList("z"), (Object)2));
        this.assertFunction("array_frequency(array[array[varchar 'z'], array[varchar 't']])", (Type)BlockAssertions.createMapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)IntegerType.INTEGER), ImmutableMap.of(Collections.singletonList("z"), (Object)1, Collections.singletonList("t"), (Object)1));
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((Type)IntegerType.INTEGER), (Object)RowType.field((Type)IntegerType.INTEGER)));
        String t = rowType.toString();
        this.assertFunction("array_frequency(array[(1, 2), (1, 3), (1, 2)])", (Type)BlockAssertions.createMapType((Type)rowType, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)2, (Object)ImmutableList.of((Object)1, (Object)3), (Object)1));
        this.assertInvalidFunction("array_frequency(array[(1, null), (null, 2), (null, 1)])", StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        this.assertInvalidFunction("array_frequency(array[(null, 1), (1, null), (null, null)])", StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
    }

    @Test
    public void testArrayHasDuplicates() {
        this.assertFunction("array_has_duplicates(cast(null as array(varchar)))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("array_has_duplicates(cast(array[] as array(varchar)))", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("array_has_duplicates(array[varchar 'a', varchar 'b', varchar 'a'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[varchar 'a', varchar 'b'])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("array_has_duplicates(array[varchar 'a', varchar 'a'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[1, 2, 1])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[1, 2])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("array_has_duplicates(array[1, 1, 1])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[0, null])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("array_has_duplicates(array[0, null, null])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_dupes(array[varchar 'a', varchar 'b', varchar 'a'])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[array[1], array[2], array[]])", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("array_has_duplicates(array[array[1], array[2], array[2]])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[(1, 2), (1, 2)])", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("array_has_duplicates(array[(1, 2), (2, 2)])", (Type)BooleanType.BOOLEAN, false);
        this.assertInvalidFunction("array_has_duplicates(array[(1, null), (null, 2), (null, 1)])", StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        this.assertInvalidFunction("array_has_duplicates(array[(1, null), (null, 2), (null, null)])", StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
    }

    @Test
    public void testArrayDuplicates() {
        this.assertFunction("array_duplicates(cast(null as array(varchar)))", (Type)new ArrayType((Type)VarcharType.VARCHAR), null);
        this.assertFunction("array_duplicates(cast(array[] as array(varchar)))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of());
        this.assertFunction("array_duplicates(array[varchar 'a', varchar 'b', varchar 'a'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"a"));
        this.assertFunction("array_duplicates(array[varchar 'a', varchar 'b'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of());
        this.assertFunction("array_duplicates(array[varchar 'a', varchar 'a'])", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"a"));
        this.assertFunction("array_duplicates(array[1, 2, 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("array_duplicates(array[1, 2])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_duplicates(array[1, 1, 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("array_duplicates(array[0, null])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("array_duplicates(array[0, null, null])", (Type)new ArrayType((Type)IntegerType.INTEGER), Collections.singletonList(null));
        this.assertFunction("array_dupes(array[1, 2, 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((Type)IntegerType.INTEGER), (Object)RowType.field((Type)IntegerType.INTEGER)));
        String t = rowType.toString();
        this.assertFunction("array_duplicates(array[array[1], array[2], array[]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of());
        this.assertFunction("array_duplicates(array[array[1], array[2], array[2]])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)2)));
        this.assertFunction("array_duplicates(array[(1, 2), (1, 2)])", (Type)new ArrayType((Type)rowType), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2)));
        this.assertFunction("array_duplicates(array[(1, 2), (2, 2)])", (Type)new ArrayType((Type)rowType), ImmutableList.of());
        this.assertInvalidFunction("array_duplicates(array[(1, null), (null, 2), (null, 1)])", StandardErrorCode.NOT_SUPPORTED, "ROW comparison not supported for fields with null elements");
        this.assertInvalidFunction("array_duplicates(array[(1, null), (null, 2), (null, null)])", StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
    }

    @Test
    public void testArrayLeastFrequent() {
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 2, 2, 3, 3, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY ['a', 'b', 'b', 'c', 'c', 'c'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"a"));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 1, 2, 2, 3, 3])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [DOUBLE '1.0', DOUBLE '2.0', DOUBLE '3.0'])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(1.0));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY ['abc', 'bc', 'aaa'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"aaa"));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY ['', '', ' '])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)" "));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(null)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 2, 2, NULL])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [NULL, NULL, NULL])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((Type)IntegerType.INTEGER), (Object)RowType.field((Type)IntegerType.INTEGER)));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [ROW(1, 2), ROW(2, 3), ROW(2, 3)])", (Type)new ArrayType((Type)rowType), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2)));
    }

    @Test
    public void testArrayNLeastFrequent() {
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 2, 2, 3, 3, 3], 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY ['a', 'b', 'b', 'c', 'c', 'c'], 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 1, 2, 2, 3, 3], 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [DOUBLE '1.0', DOUBLE '2.0', DOUBLE '3.0'], 2)", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(1.0, 2.0));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY ['abc', 'bc', 'aaa'], 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"aaa", (Object)"abc", (Object)"bc"));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY ['', '', ' '], 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)" "));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [], 2)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(null, 3)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [NULL], 0)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [NULL, NULL, NULL], 1)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 2, 2, NULL], 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), Collections.emptyList());
        this.assertInvalidFunction("ARRAY_LEAST_FREQUENT(ARRAY ['a', 'b', 'b', 'c', 'c', 'c'], -1)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [1, 2, 2, 3, 3, 3, -1], 5)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)-1, (Object)1, (Object)2, (Object)3));
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((Type)IntegerType.INTEGER), (Object)RowType.field((Type)IntegerType.INTEGER)));
        this.assertFunction("ARRAY_LEAST_FREQUENT(ARRAY [ROW(1, 2), ROW(2, 3), ROW(2, 3)], 2)", (Type)new ArrayType((Type)rowType), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)2, (Object)3)));
    }

    @Test
    public void testArrayMaxBy() {
        this.assertFunction("ARRAY_MAX_BY(ARRAY [double'1.0', double'2.0'], i -> i)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("ARRAY_MAX_BY(ARRAY [double'-3.0', double'2.0'], i -> i*i)", (Type)DoubleType.DOUBLE, -3.0);
        this.assertFunction("ARRAY_MAX_BY(ARRAY ['a', 'bb', 'c'], x -> LENGTH(x))", (Type)VarcharType.createVarcharType((int)2), "bb");
        this.assertFunction("ARRAY_MAX_BY(ARRAY [1, 2, 3], x -> 1-x)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("ARRAY_MAX_BY(ARRAY [ARRAY['a'], ARRAY['b', 'b'], ARRAY['c']], x -> CARDINALITY(x))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), Arrays.asList("b", "b"));
        this.assertFunction("ARRAY_MAX_BY(ARRAY [MAP(ARRAY['foo', 'bar'], ARRAY[1, 2]), MAP(ARRAY['foo', 'bar'], ARRAY[0, 3])], x -> x['foo'])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"foo", (Object)1, (Object)"bar", (Object)2));
        this.assertFunction("ARRAY_MAX_BY(ARRAY [CAST(ROW(0, 2.0) AS ROW(x BIGINT, y DOUBLE)), CAST(ROW(1, 3.0) AS ROW(x BIGINT, y DOUBLE))], r -> r.y).x", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("ARRAY_MAX_BY(ARRAY [null, double'1.0', double'2.0'], i -> i)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ARRAY_MAX_BY(ARRAY [cast(null as double), cast(null as double)], i -> i)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ARRAY_MAX_BY(cast(null as array(double)), i -> i)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testArrayMinBy() {
        this.assertFunction("ARRAY_MIN_BY(ARRAY [double'1.0', double'2.0'], i -> i)", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("ARRAY_MIN_BY(ARRAY [double'-3.0', double'2.0'], i -> i*i)", (Type)DoubleType.DOUBLE, 2.0);
        this.assertFunction("ARRAY_MIN_BY(ARRAY ['a', 'bb', 'c'], x -> LENGTH(x))", (Type)VarcharType.createVarcharType((int)2), "a");
        this.assertFunction("ARRAY_MIN_BY(ARRAY [1, 2, 3], x -> 1-x)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("ARRAY_MIN_BY(ARRAY [ARRAY['a'], ARRAY['b', 'b'], ARRAY['c']], x -> CARDINALITY(x))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), Collections.singletonList("a"));
        this.assertFunction("ARRAY_MIN_BY(ARRAY [MAP(ARRAY['foo', 'bar'], ARRAY[1, 2]), MAP(ARRAY['foo', 'bar'], ARRAY[0, 3])], x -> x['foo'])", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"foo", (Object)0, (Object)"bar", (Object)3));
        this.assertFunction("ARRAY_MIN_BY(ARRAY [CAST(ROW(0, 2.0) AS ROW(x BIGINT, y DOUBLE)), CAST(ROW(1, 3.0) AS ROW(x BIGINT, y DOUBLE))], r -> r.y).x", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("ARRAY_MIN_BY(ARRAY [null, double'1.0', double'2.0'], i -> i)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ARRAY_MIN_BY(ARRAY [cast(null as double), cast(null as double)], i -> i)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("ARRAY_MIN_BY(cast(null as array(double)), i -> i)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testArraySortDesc() {
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [100, 1, 10, 50])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)100, (Object)50, (Object)10, (Object)1));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [null, null, 100, 1, 10, 50])", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(100, 50, 10, 1, null, null));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [double'1.0', double'2.0'])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)2.0, (Object)1.0));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [double'1.0', double'2.0'])", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)2.0, (Object)1.0));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [null, double'-3.0', double'2.0', null])", (Type)new ArrayType((Type)DoubleType.DOUBLE), Arrays.asList(2.0, -3.0, null, null));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY ['a', 'bb', 'c'])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of((Object)"c", (Object)"bb", (Object)"a"));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY ['a', 'bb', 'c', null])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), Arrays.asList("c", "bb", "a", null));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [null, null, null])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(null, null, null));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [])", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Collections.emptyList());
        this.assertFunction("ARRAY_SORT_DESC(null)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [ARRAY['a'], ARRAY['b', 'b'], ARRAY['c']])", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), ImmutableList.of((Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"b", (Object)"b"), (Object)ImmutableList.of((Object)"a")));
        this.assertFunction("ARRAY_SORT_DESC(ARRAY [ARRAY['a'], ARRAY['b', 'b'], ARRAY['c'], null, null, ARRAY['a', NULL]])", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))), Arrays.asList(Collections.singletonList("c"), ImmutableList.of((Object)"b", (Object)"b"), Arrays.asList("a", null), Collections.singletonList("a"), null, null));
        this.assertInvalidFunction("ARRAY_SORT_DESC(ARRAY [ROW('a', 1), ROW('a', null), null, ROW('a', 0)])", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("ARRAY_SORT_DESC(ARRAY [MAP(ARRAY['foo', 'bar'], ARRAY[1, 2]), MAP(ARRAY['foo', 'bar'], ARRAY[0, 3])])", SemanticErrorCode.FUNCTION_NOT_FOUND);
    }

    @Test
    public void testArrayTopN() {
        this.assertFunction("ARRAY_TOP_N(ARRAY [1, 1, 1, 1], 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)1, (Object)1));
        this.assertFunction("ARRAY_TOP_N(ARRAY [1, 100, 2, 5, 3], 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)100, (Object)5, (Object)3));
        this.assertFunction("ARRAY_TOP_N(ARRAY [DOUBLE '1.0', DOUBLE '100.0', DOUBLE '2.0', DOUBLE '5.0', DOUBLE '3.0'], 3)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)100.0, (Object)5.0, (Object)3.0));
        this.assertFunction("ARRAY_TOP_N(ARRAY [DOUBLE '1.0', 100, 2, DOUBLE '5.0', DOUBLE '3.0'], 3)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)100.0, (Object)5.0, (Object)3.0));
        this.assertFunction("ARRAY_TOP_N(ARRAY [1, 4, null], 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(4, 1, null));
        this.assertFunction("ARRAY_TOP_N(ARRAY ['a', 'z', 'd', 'f', 'g', 'b'], 4)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"z", (Object)"g", (Object)"f", (Object)"d"));
        this.assertFunction("ARRAY_TOP_N(ARRAY ['foo', 'bar', 'lorem', 'ipsum', 'lorem2'], 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)6)), ImmutableList.of((Object)"lorem2", (Object)"lorem", (Object)"ipsum"));
        this.assertFunction("ARRAY_TOP_N(ARRAY ['a', 'zzz', 'zz', 'b', 'g', 'f'], 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"zzz", (Object)"zz", (Object)"g"));
        this.assertFunction("ARRAY_TOP_N(ARRAY ['a', 'a', 'd', 'a', 'a', 'a'], 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of((Object)"d", (Object)"a", (Object)"a"));
        this.assertFunction("ARRAY_TOP_N(ARRAY [true, true, false, true, false], 4)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)true, (Object)true, (Object)false));
        this.assertFunction("ARRAY_TOP_N(ARRAY [100, 1, 3, -10, 6, -5], 3, (x, y) -> IF(abs(x) < abs(y), -1, IF(abs(x) = abs(y), 0, 1)))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)100, (Object)-10, (Object)6));
        RowType rowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"x", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"y", (Type)IntegerType.INTEGER)));
        this.assertFunction("ARRAY_TOP_N(ARRAY [CAST(ROW(1, 2) AS ROW(x INT, y INT)), CAST(ROW(0, 11) AS ROW(x INT, y INT)), CAST(ROW(5, 10) AS ROW(x INT, y INT))], 2, (a, b) -> IF(a.x*a.y < b.x*b.y, -1, IF(a.x*a.y = b.x*b.y, 0, 1)))", (Type)new ArrayType((Type)rowType), ImmutableList.of((Object)ImmutableList.of((Object)5, (Object)10), (Object)ImmutableList.of((Object)1, (Object)2)));
        this.assertInvalidFunction("ARRAY_TOP_N(ARRAY [ROW('a', 1), ROW('a', null), null, ROW('a', 0)], 2)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("ARRAY_TOP_N(ARRAY [MAP(ARRAY['foo', 'bar'], ARRAY[1, 2]), MAP(ARRAY['foo', 'bar'], ARRAY[0, 3])], 2)", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("ARRAY_TOP_N(ARRAY ['a', 'a', 'd', 'a', 'a', 'a'], -1)", StandardErrorCode.GENERIC_USER_ERROR, "Parameter n: -1 to ARRAY_TOP_N is negative");
        this.assertFunction("ARRAY_TOP_N(ARRAY [null, null], 3)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Arrays.asList(null, null));
        this.assertFunction("ARRAY_TOP_N(ARRAY [3, 5, 1, 2], 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), Collections.emptyList());
        this.assertFunction("ARRAY_TOP_N(ARRAY [], 3)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), Collections.emptyList());
        this.assertFunction("ARRAY_TOP_N(ARRAY [1, 4], 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)4, (Object)1));
    }
}

