/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import org.testng.annotations.Test;

public class TestMapRemoveNullValuesFunction
extends AbstractTestFunctions {
    @Test
    public void test() {
        this.assertFunction("MAP_REMOVE_NULL_VALUES(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)4, (Object)2, (Object)5, (Object)3, (Object)6));
        this.assertFunction("MAP_REMOVE_NULL_VALUES(MAP(ARRAY[-1, -2, -3], ARRAY[null, 5.0, null]))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DecimalType.createDecimalType((int)2, (int)1)), ImmutableMap.of((Object)-2, (Object)TestMapRemoveNullValuesFunction.decimal("5.0")));
        this.assertFunction("MAP_REMOVE_NULL_VALUES(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY[null, null, null]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)UnknownType.UNKNOWN), Collections.emptyMap());
        this.assertFunction("MAP_REMOVE_NULL_VALUES(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']))", (Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)6, (int)2), (Type)VarcharType.createVarcharType((int)1)), ImmutableMap.of((Object)TestMapRemoveNullValuesFunction.decimal("123.00"), (Object)"x", (Object)TestMapRemoveNullValuesFunction.decimal("99.50"), (Object)"y", (Object)TestMapRemoveNullValuesFunction.decimal("1000.99"), (Object)"z"));
        this.assertFunction("MAP_REMOVE_NULL_VALUES(MAP(ARRAY['a', 'b', 'c'], ARRAY[ARRAY[1], ARRAY[], ARRAY[null]]))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableMap.of((Object)"a", Collections.singletonList(1), (Object)"b", Collections.emptyList(), (Object)"c", Collections.singletonList(null)));
        this.assertFunction("MAP_REMOVE_NULL_VALUES(MAP(ARRAY[], ARRAY[]))", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), Collections.emptyMap());
        this.assertFunction("MAP_REMOVE_NULL_VALUES(null)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), null);
    }
}

