/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapTopNValuesFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY[1, 2, 3]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3, (Object)2));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY[-1, -2, -3]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)-1, (Object)-2));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY['x', 'y', 'z'], ARRAY['ab', 'bc', 'cd']), 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of((Object)"cd"));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY['x', 'y', 'z'], ARRAY[123.0, 99.5, 1000.99]), 3)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)6, (int)2)), ImmutableList.of((Object)TestMapTopNValuesFunction.decimal("1000.99"), (Object)TestMapTopNValuesFunction.decimal("123.00"), (Object)TestMapTopNValuesFunction.decimal("99.50")));
    }

    @Test
    public void tesMayHaveNull() {
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY[1, null, 3]), 3)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(3, 1, null));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY[-1, -2, null]), 2)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(-1, -2));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY['x', 'y', 'z'], ARRAY[null, 'bc', 'cd']), 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), Arrays.asList("cd", "bc", null));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY['x', 'y', 'z'], ARRAY[123.0, 99.5, null]), 3)", (Type)new ArrayType((Type)DecimalType.createDecimalType((int)4, (int)1)), Arrays.asList(TestMapTopNValuesFunction.decimal("123.0"), TestMapTopNValuesFunction.decimal("99.5"), null));
    }

    @Test
    public void testNegativeN() {
        this.assertInvalidFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY[1, null, 3]), -1)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
        this.assertInvalidFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY['a', 'b', 'c']), -2)", StandardErrorCode.GENERIC_USER_ERROR, "n must be greater than or equal to 0");
    }

    @Test
    public void testZeroN() {
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY[1, null, 3]), 0)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of());
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[4, 5, 6], ARRAY['a', 'b', 'c']), 0)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)), ImmutableList.of());
    }

    @Test
    public void testEmpty() {
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[], ARRAY[]), 5)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), ImmutableList.of());
    }

    @Test
    public void testNull() {
        this.assertFunction("MAP_TOP_N_VALUES(NULL, 1)", (Type)new ArrayType((Type)UnknownType.UNKNOWN), null);
    }

    @Test
    public void testComplexValues() {
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[1, 2], ARRAY[ROW('x', 1), ROW('y', 2)]), 1)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"y", (Object)2)));
        this.assertFunction("MAP_TOP_N_VALUES(MAP(ARRAY[1, 2], ARRAY[ROW('x', 1), ROW('x', -2)]), 1)", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((Type)VarcharType.createVarcharType((int)1)), (Object)RowType.field((Type)IntegerType.INTEGER)))), ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)1)));
    }
}

