/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import org.testng.annotations.Test;

public class TestNoKeysMatchFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]), (x) -> x > 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[-1, -2, -3], ARRAY[4, 5, 6]), (x) -> x < -2)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY['ab', 'bc', 'cd'], ARRAY['x', 'y', 'z']), (x) -> x IS NULL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[123.0, 99.5, 1000.99], ARRAY['x', 'y', 'z']), (x) -> x > 1.0)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testEmpty() {
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[], ARRAY[]), (x) -> x > 0)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[], ARRAY[]), (x) -> x IS NULL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NO_KEYS_MATCH(MAP(), (x) -> FALSE)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNull() {
        this.assertFunction("NO_KEYS_MATCH(NULL, (x) -> x LIKE '%ab%')", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY['x', 'y'], ARRAY[1, 2]), (x) -> CAST(NULL AS BOOLEAN))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY['x', 'y'], ARRAY[1, 2]), (x) -> IF(x = 'x', false, CAST(NULL AS BOOLEAN)))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY['x', 'y', 'z'], ARRAY[1, 2, 3]), (x) -> IF(x IN ('x', 'y'), false, CAST(NULL AS BOOLEAN)))", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY['x', 'y', 'z'], ARRAY[1, 2, 3]), (x) -> IF(x = 'x', false, IF(x = 'y', true, CAST(NULL AS BOOLEAN))))", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testComplexKeys() {
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[ROW('x', 1), ROW('y', 2)], ARRAY[1, 2]), (x) -> x[1] = 'x')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[ROW('x', 1), ROW('x', -2)], ARRAY[2, 1]), (x) -> x[2] >= 2)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NO_KEYS_MATCH(MAP(ARRAY[ROW('x', 1), ROW('x', -2), ROW('y', 1)], ARRAY[100, 200, null]), (x) -> x[1] = 'ab')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testError() {
        this.assertInvalidFunction("NO_KEYS_MATCH(MAP(ARRAY[ROW('x', 1), ROW('y', 2)], ARRAY[1, 2]), (x) -> x[2] LIKE '%ab%')", SemanticErrorCode.TYPE_MISMATCH);
        this.assertInvalidFunction("NO_KEYS_MATCH(MAP(ARRAY[1, 2, 3], ARRAY[4, 5, 6]))", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("NO_KEYS_MATCH(MAP(ARRAY['a', 'b', 'c'], ARRAY[4, 5, 6]), 1)", SemanticErrorCode.FUNCTION_NOT_FOUND);
    }
}

