/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import org.testng.annotations.Test;

public class TestReplaceFirstFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("REPLACE_FIRST('aaa', 'a', 'b')", (Type)VarcharType.VARCHAR, "baa");
        this.assertFunction("REPLACE_FIRST('replace_all', 'all', 'first')", (Type)VarcharType.VARCHAR, "replace_first");
        this.assertFunction("REPLACE_FIRST('The quick brown dog jumps over a lazy dog', 'dog', 'fox')", (Type)VarcharType.VARCHAR, "The quick brown fox jumps over a lazy dog");
        this.assertFunction("REPLACE_FIRST('John  Doe', ' ', '')", (Type)VarcharType.VARCHAR, "John Doe");
        this.assertFunction("REPLACE_FIRST('We will fight for our rights, for our rights.', ', for our rights', '')", (Type)VarcharType.VARCHAR, "We will fight for our rights.");
        this.assertFunction("REPLACE_FIRST('Testcases test cases', 'cases', '')", (Type)VarcharType.VARCHAR, "Test test cases");
        this.assertFunction("REPLACE_FIRST('test cases', '', 'Add ')", (Type)VarcharType.VARCHAR, "Add test cases");
    }

    @Test
    public void testEmpty() {
        this.assertFunction("REPLACE_FIRST('', 'a', 'b')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("REPLACE_FIRST('', '', 'test')", (Type)VarcharType.VARCHAR, "test");
        this.assertFunction("REPLACE_FIRST('', 'a', '')", (Type)VarcharType.VARCHAR, "");
    }

    @Test
    public void testNull() {
        this.assertFunction("REPLACE_FIRST(NULL, 'foo', 'bar')", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("REPLACE_FIRST('foo', NULL, 'bar')", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("REPLACE_FIRST('foo', 'bar', NULL)", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("REPLACE_FIRST(NULL, NULL, 'test')", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("REPLACE_FIRST('foo', 'NULL', NULL)", (Type)VarcharType.VARCHAR, null);
    }

    @Test
    public void testError() {
        this.assertInvalidFunction("REPLACE_FIRST(1000, '1000', '100')", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("REPLACE_FIRST('1000.0', 1000.0, '100')", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("REPLACE_FIRST('1000', '1000', 100)", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("REPLACE_FIRST('replace first')", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("REPLACE_FIRST('replace first', 'first')", SemanticErrorCode.FUNCTION_NOT_FOUND);
    }
}

