/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import org.testng.annotations.Test;

public class TestTrailFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("TRAIL('foobar', 3)", (Type)VarcharType.VARCHAR, "bar");
        this.assertFunction("TRAIL('foobar', 7)", (Type)VarcharType.VARCHAR, "foobar");
        this.assertFunction("TRAIL('foobar', 0)", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("TRAIL('foobar', -1)", (Type)VarcharType.VARCHAR, "");
    }

    @Test
    public void testEmpty() {
        this.assertFunction("TRAIL('', 3)", (Type)VarcharType.VARCHAR, "");
    }

    @Test
    public void testNull() {
        this.assertFunction("TRAIL(CAST(NULL AS VARCHAR), 3)", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("TRAIL('foobar', NULL)", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("TRAIL(NULL, 3)", (Type)VarcharType.VARCHAR, null);
    }

    @Test
    public void testError() {
        this.assertInvalidFunction("TRAIL('foobar', 'three')", SemanticErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("TRAIL(3, 3)", SemanticErrorCode.FUNCTION_NOT_FOUND);
    }
}

