/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TestingResourceManagerClient
implements ResourceManagerClient {
    private final AtomicInteger queryHeartbeats = new AtomicInteger();
    private final AtomicInteger nodeHeartbeats = new AtomicInteger();
    private final AtomicInteger resourceGroupRuntimeHeartbeats = new AtomicInteger();
    private final Map<String, Integer> resourceGroupInfoCalls = new ConcurrentHashMap<String, Integer>();
    private volatile List<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfos = ImmutableList.of();
    private int runningTaskCount;

    public void queryHeartbeat(String internalNode, BasicQueryInfo basicQueryInfo, long sequenceId) {
        this.queryHeartbeats.incrementAndGet();
    }

    public List<ResourceGroupRuntimeInfo> getResourceGroupInfo(String excludingNode) {
        this.resourceGroupInfoCalls.putIfAbsent(excludingNode, 0);
        this.resourceGroupInfoCalls.compute(excludingNode, (s, integer) -> integer + 1);
        return this.resourceGroupRuntimeInfos;
    }

    public void setResourceGroupRuntimeInfos(List<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfos) {
        this.resourceGroupRuntimeInfos = ImmutableList.copyOf(resourceGroupRuntimeInfos);
    }

    public void setRunningTaskCount(int runningTaskCount) {
        this.runningTaskCount = runningTaskCount;
    }

    public void nodeHeartbeat(NodeStatus nodeStatus) {
        this.nodeHeartbeats.incrementAndGet();
    }

    public Map<MemoryPoolId, ClusterMemoryPoolInfo> getMemoryPoolInfo() {
        return ImmutableMap.of();
    }

    public void resourceGroupRuntimeHeartbeat(String node, List<ResourceGroupRuntimeInfo> resourceGroupRuntimeInfo) {
        this.resourceGroupRuntimeHeartbeats.incrementAndGet();
    }

    public int getQueryHeartbeats() {
        return this.queryHeartbeats.get();
    }

    public int getNodeHeartbeats() {
        return this.nodeHeartbeats.get();
    }

    public int getResourceGroupInfoCalls(String identifier) {
        return this.resourceGroupInfoCalls.get(identifier);
    }

    public int getResourceGroupRuntimeHeartbeats() {
        return this.resourceGroupRuntimeHeartbeats.get();
    }

    public int getRunningTaskCount() {
        return this.runningTaskCount;
    }
}

