/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.Session;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManager;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManagerFactory;
import com.facebook.presto.spi.session.TestingSessionPropertyConfigurationManagerFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSessionPropertyDefaults {
    private static final ResourceGroupId TEST_RESOURCE_GROUP_ID = new ResourceGroupId("test");
    private static final NodeInfo TEST_NODE_INFO = new NodeInfo("test");
    private static final NodeVersion TEST_NODE_VERSION = new NodeVersion("testversion");

    @Test
    public void testApplyDefaultProperties() {
        SessionPropertyDefaults sessionPropertyDefaults = new SessionPropertyDefaults(TEST_NODE_INFO, TEST_NODE_VERSION);
        TestingSessionPropertyConfigurationManagerFactory factory = new TestingSessionPropertyConfigurationManagerFactory(new SessionPropertyConfigurationManager.SystemSessionPropertyConfiguration((Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"override").put((Object)"system_default", (Object)"system_default").build(), (Map)ImmutableMap.of((Object)"override", (Object)"overridden")), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"override").put((Object)"catalog_default", (Object)"catalog_default").build()));
        sessionPropertyDefaults.addConfigurationManagerFactory((SessionPropertyConfigurationManagerFactory)factory);
        sessionPropertyDefaults.setConfigurationManager(factory.getName(), (Map)ImmutableMap.of());
        Session session = Session.builder((SessionPropertyManager)new SessionPropertyManager()).setQueryId(new QueryId("test_query_id")).setIdentity(new Identity("testUser", Optional.empty())).setSystemProperty("query_max_memory", "1GB").setSystemProperty("join_distribution_type", "partitioned").setSystemProperty("hash_partition_count", "43").setSystemProperty("cte_hash_partition_count", "100").setSystemProperty("override", "should be overridden").setCatalogSessionProperty("testCatalog", "explicit_set", "explicit_set").build();
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").put((Object)"cte_hash_partition_count", (Object)"100").put((Object)"override", (Object)"should be overridden").build());
        Assert.assertEquals((Map)session.getUnprocessedCatalogProperties(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").build()));
        session = sessionPropertyDefaults.newSessionWithDefaultProperties(session, Optional.empty(), Optional.of(TEST_RESOURCE_GROUP_ID));
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").put((Object)"cte_hash_partition_count", (Object)"100").put((Object)"system_default", (Object)"system_default").put((Object)"override", (Object)"overridden").build());
        Assert.assertEquals((Map)session.getUnprocessedCatalogProperties(), (Map)ImmutableMap.of((Object)"testCatalog", (Object)ImmutableMap.builder().put((Object)"explicit_set", (Object)"explicit_set").put((Object)"catalog_default", (Object)"catalog_default").build()));
    }
}

