/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.utils.DataSizeToBytesThriftCodec;
import com.facebook.drift.codec.utils.JodaDateTimeToEpochMillisThriftCodec;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.server.ThreadResource;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestThreadResource {
    private static final ThriftCatalog COMMON_CATALOG = new ThriftCatalog();
    private static final DataSizeToBytesThriftCodec DATA_SIZE_CODEC = new DataSizeToBytesThriftCodec(COMMON_CATALOG);
    private static final JodaDateTimeToEpochMillisThriftCodec DATE_TIME_CODEC = new JodaDateTimeToEpochMillisThriftCodec(COMMON_CATALOG);
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<ThreadResource.Info> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(ThreadResource.Info.class);
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<ThreadResource.Info> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(ThreadResource.Info.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<ThreadResource.Info> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(ThreadResource.Info.class);
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<ThreadResource.Info> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(ThreadResource.Info.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private static final String FAKE_FILE_1 = "/fake/com/facebook/presto/server/Fake1.java";
    private static final String FAKE_FILE_2 = "/fake/com/facebook/presto/server/Fake2.java";
    private static final String FAKE_FILE_3 = "/fake/com/facebook/presto/server/Fake3.java";
    private static final int FAKE_LINE_1 = 1;
    private static final int FAKE_LINE_2 = 2;
    private static final int FAKE_LINE_3 = 3;
    private static final String FAKE_CLASSNAME_1 = "com.facebook.presto.server.Fake1";
    private static final String FAKE_CLASSNAME_2 = "com.facebook.presto.server.Fake2";
    private static final String FAKE_CLASSNAME_3 = "com.facebook.presto.server.Fake3";
    private static final String FAKE_METHOD_1 = "fake1";
    private static final String FAKE_METHOD_2 = "fake2";
    private static final String FAKE_METHOD_3 = "fake3";
    private static final long FAKE_ID = 1234L;
    private static final String FAKE_NAME = "Thread-1";
    private static final String FAKE_STATE = "blocked";
    private static final Long FAKE_LOCK_OWNER_ID = 1235L;
    private ThreadResource.Info info;

    @BeforeMethod
    public void setUp() {
        ArrayList<ThreadResource.StackLine> stackLines = new ArrayList<ThreadResource.StackLine>();
        stackLines.add(new ThreadResource.StackLine(FAKE_FILE_1, 1, FAKE_CLASSNAME_1, FAKE_METHOD_1));
        stackLines.add(new ThreadResource.StackLine(FAKE_FILE_2, 2, FAKE_CLASSNAME_2, FAKE_METHOD_2));
        stackLines.add(new ThreadResource.StackLine(FAKE_FILE_3, 3, FAKE_CLASSNAME_3, FAKE_METHOD_3));
        this.info = new ThreadResource.Info(1234L, FAKE_NAME, FAKE_STATE, FAKE_LOCK_OWNER_ID, stackLines);
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<ThreadResource.Info> readCodec, ThriftCodec<ThreadResource.Info> writeCodec) throws Exception {
        ThreadResource.Info serializedInfo = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertInfo(serializedInfo);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<ThreadResource.Info> readCodec, ThriftCodec<ThreadResource.Info> writeCodec) throws Exception {
        ThreadResource.Info serializedInfo = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertInfo(serializedInfo);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<ThreadResource.Info> readCodec, ThriftCodec<ThreadResource.Info> writeCodec) throws Exception {
        ThreadResource.Info serializedInfo = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertInfo(serializedInfo);
    }

    private void assertStackLines(List<ThreadResource.StackLine> stackLines) {
        Assert.assertEquals((String)stackLines.get(0).getFile(), (String)FAKE_FILE_1);
        Assert.assertEquals((int)stackLines.get(0).getLine(), (int)1);
        Assert.assertEquals((String)stackLines.get(0).getClassName(), (String)FAKE_CLASSNAME_1);
        Assert.assertEquals((String)stackLines.get(0).getMethod(), (String)FAKE_METHOD_1);
        Assert.assertEquals((String)stackLines.get(1).getFile(), (String)FAKE_FILE_2);
        Assert.assertEquals((int)stackLines.get(1).getLine(), (int)2);
        Assert.assertEquals((String)stackLines.get(1).getClassName(), (String)FAKE_CLASSNAME_2);
        Assert.assertEquals((String)stackLines.get(1).getMethod(), (String)FAKE_METHOD_2);
        Assert.assertEquals((String)stackLines.get(2).getFile(), (String)FAKE_FILE_3);
        Assert.assertEquals((int)stackLines.get(2).getLine(), (int)3);
        Assert.assertEquals((String)stackLines.get(2).getClassName(), (String)FAKE_CLASSNAME_3);
        Assert.assertEquals((String)stackLines.get(2).getMethod(), (String)FAKE_METHOD_3);
    }

    private void assertInfo(ThreadResource.Info actualInfo) {
        Assert.assertEquals((long)actualInfo.getId(), (long)1234L);
        Assert.assertEquals((String)actualInfo.getName(), (String)FAKE_NAME);
        Assert.assertEquals((String)actualInfo.getState(), (String)FAKE_STATE);
        Assert.assertEquals((Object)actualInfo.getLockOwnerId(), (Object)FAKE_LOCK_OWNER_ID);
        this.assertStackLines(actualInfo.getStackTrace());
    }

    private ThreadResource.Info getRoundTripSerialize(ThriftCodec<ThreadResource.Info> readCodec, ThriftCodec<ThreadResource.Info> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.info, (TProtocolWriter)protocol);
        return (ThreadResource.Info)readCodec.read((TProtocolReader)protocol);
    }
}

