/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.server.ClusterStatsResource;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestThriftClusterStats {
    public static final long RUNNING_QUERIES = 20L;
    public static final long BLOCKED_QUERIES = 21L;
    public static final long QUEUED_QUERIES = 22L;
    public static final long ACTIVE_WORKERS = 12L;
    public static final long RUNNING_DRIVERS = 13L;
    public static final long RUNNING_TASKS = 101L;
    public static final double RESERVED_MEMORY = 1001.5;
    public static final long TOTAL_INPUT_ROWS = 1002L;
    public static final long TOTAL_INPUT_BYTES = 1003L;
    public static final long TOTAL_CPU_TIME_SECS = 1004L;
    public static final long ADJUSTED_QUEUE_SIZE = 1005L;
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodec<ClusterStatsResource.ClusterStats> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(ClusterStatsResource.ClusterStats.class);
    private static final ThriftCodec<ClusterStatsResource.ClusterStats> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(ClusterStatsResource.ClusterStats.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final ThriftCodec<ClusterStatsResource.ClusterStats> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(ClusterStatsResource.ClusterStats.class);
    private static final ThriftCodec<ClusterStatsResource.ClusterStats> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(ClusterStatsResource.ClusterStats.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private ClusterStatsResource.ClusterStats clusterStats;

    @BeforeMethod
    public void setUp() {
        this.clusterStats = this.getClusterStats();
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<ClusterStatsResource.ClusterStats> readCodec, ThriftCodec<ClusterStatsResource.ClusterStats> writeCodec) throws Exception {
        ClusterStatsResource.ClusterStats clusterStats = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertSerde(clusterStats);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<ClusterStatsResource.ClusterStats> readCodec, ThriftCodec<ClusterStatsResource.ClusterStats> writeCodec) throws Exception {
        ClusterStatsResource.ClusterStats clusterStats = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertSerde(clusterStats);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<ClusterStatsResource.ClusterStats> readCodec, ThriftCodec<ClusterStatsResource.ClusterStats> writeCodec) throws Exception {
        ClusterStatsResource.ClusterStats clusterStats = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertSerde(clusterStats);
    }

    private void assertSerde(ClusterStatsResource.ClusterStats clusterStats) {
        Assert.assertEquals((long)clusterStats.getRunningQueries(), (long)20L);
        Assert.assertEquals((long)clusterStats.getBlockedQueries(), (long)21L);
        Assert.assertEquals((long)clusterStats.getQueuedQueries(), (long)22L);
        Assert.assertEquals((long)clusterStats.getActiveWorkers(), (long)12L);
        Assert.assertEquals((long)clusterStats.getRunningDrivers(), (long)13L);
        Assert.assertEquals((long)clusterStats.getRunningTasks(), (long)101L);
        Assert.assertEquals((double)clusterStats.getReservedMemory(), (double)1001.5);
        Assert.assertEquals((long)clusterStats.getTotalInputRows(), (long)1002L);
        Assert.assertEquals((long)clusterStats.getTotalInputBytes(), (long)1003L);
        Assert.assertEquals((long)clusterStats.getTotalCpuTimeSecs(), (long)1004L);
        Assert.assertEquals((long)clusterStats.getAdjustedQueueSize(), (long)1005L);
    }

    private ClusterStatsResource.ClusterStats getRoundTripSerialize(ThriftCodec<ClusterStatsResource.ClusterStats> readCodec, ThriftCodec<ClusterStatsResource.ClusterStats> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.clusterStats, (TProtocolWriter)protocol);
        return (ClusterStatsResource.ClusterStats)readCodec.read((TProtocolReader)protocol);
    }

    private ClusterStatsResource.ClusterStats getClusterStats() {
        return new ClusterStatsResource.ClusterStats(20L, 21L, 22L, 12L, 13L, 101L, 1001.5, 1002L, 1003L, 1004L, 1005L);
    }
}

