/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.drift.client.DriftClientFactory;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.server.DriftServer;
import com.facebook.drift.server.guice.DriftServerBinder;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvokerFactory;
import com.facebook.drift.transport.netty.server.DriftNettyServerModule;
import com.facebook.drift.transport.netty.server.DriftNettyServerTransport;
import com.facebook.presto.Session;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.server.GracefulShutdownHandler;
import com.facebook.presto.server.NodeStatusNotificationManager;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.ShutdownAction;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.server.thrift.ThriftServerInfoClient;
import com.facebook.presto.server.thrift.ThriftServerInfoService;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestThriftServerInfoIntegration {
    private LifeCycleManager lifeCycleManager;
    private int thriftServerPort;

    @BeforeClass
    public void setup() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new DriftNettyServerModule(), new TestingThriftServerInfoModule()});
        app.setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"presto.version", (Object)"test.0", (Object)"coordinator", (Object)"false"));
        Injector injector = app.doNotInitializeLogging().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.thriftServerPort = TestThriftServerInfoIntegration.driftServerPort((DriftServer)injector.getInstance(DriftServer.class));
    }

    @AfterClass
    public void teardown() {
        if (this.lifeCycleManager != null) {
            this.lifeCycleManager.stop();
        }
    }

    @Test
    public void testServer() {
        SimpleAddressSelector addressSelector = new SimpleAddressSelector((Iterable)ImmutableSet.of((Object)HostAndPort.fromParts((String)"localhost", (int)this.thriftServerPort)), true);
        try (DriftNettyMethodInvokerFactory invokerFactory = DriftNettyMethodInvokerFactory.createStaticDriftNettyMethodInvokerFactory((DriftNettyClientConfig)new DriftNettyClientConfig());){
            DriftClientFactory clientFactory = new DriftClientFactory(new ThriftCodecManager(new ThriftCodec[0]), (MethodInvokerFactory)invokerFactory, (AddressSelector)addressSelector, ExceptionClassifier.NORMAL_RESULT);
            ThriftServerInfoClient client = (ThriftServerInfoClient)clientFactory.createDriftClient(ThriftServerInfoClient.class).get();
            NodeState state = NodeState.valueOf((int)((Integer)client.getServerState().get()));
            Assert.assertEquals((Object)state, (Object)NodeState.ACTIVE);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private static int driftServerPort(DriftServer server) {
        return ((DriftNettyServerTransport)server.getServerTransport()).getPort();
    }

    public static class TestingThriftServerInfoModule
    implements Module {
        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(ServerConfig.class);
            binder.bind(QueryManager.class).to(NoOpQueryManager.class).in(Scopes.SINGLETON);
            binder.bind(NodeStatusNotificationManager.class).in(Scopes.SINGLETON);
            binder.bind(GracefulShutdownHandler.class).in(Scopes.SINGLETON);
            binder.bind(ShutdownAction.class).to(TestingPrestoServer.TestShutdownAction.class).in(Scopes.SINGLETON);
            binder.bind(ThriftServerInfoService.class).in(Scopes.SINGLETON);
            DriftServerBinder.driftServerBinder((Binder)binder).bindService(ThriftServerInfoService.class);
        }

        @Provides
        @Singleton
        public static TaskManager createTaskManager() {
            return new TaskManager(){

                public List<TaskInfo> getAllTaskInfo() {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo getTaskInfo(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public TaskStatus getTaskStatus(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<TaskInfo> getTaskInfo(TaskId taskId, TaskState currentState) {
                    throw new UnsupportedOperationException();
                }

                public String getTaskInstanceId(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<TaskStatus> getTaskStatus(TaskId taskId, TaskState currentState) {
                    throw new UnsupportedOperationException();
                }

                public void updateMemoryPoolAssignments(MemoryPoolAssignmentsRequest assignments) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo updateTask(Session session, TaskId taskId, Optional<PlanFragment> fragment, List<TaskSource> sources, OutputBuffers outputBuffers, Optional<TableWriteInfo> tableWriteInfo) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo cancelTask(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo abortTask(TaskId taskId) {
                    throw new UnsupportedOperationException();
                }

                public ListenableFuture<BufferResult> getTaskResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
                    throw new UnsupportedOperationException();
                }

                public void acknowledgeTaskResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId, long sequenceId) {
                    throw new UnsupportedOperationException();
                }

                public TaskInfo abortTaskResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId) {
                    throw new UnsupportedOperationException();
                }

                public void addStateChangeListener(TaskId taskId, StateMachine.StateChangeListener<TaskState> stateChangeListener) {
                    throw new UnsupportedOperationException();
                }

                public void removeRemoteSource(TaskId taskId, TaskId remoteSourceTaskId) {
                    throw new UnsupportedOperationException();
                }

                public void updateMetadataResults(TaskId taskId, MetadataUpdates metadataUpdates) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

