/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.operator.TestingOperatorContext;
import com.facebook.presto.spiller.FileSingleStreamSpillerFactory;
import com.facebook.presto.spiller.GenericPartitioningSpiller;
import com.facebook.presto.spiller.GenericPartitioningSpillerFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.PartitioningSpiller;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.TestingSpillContext;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.IntPredicate;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestGenericPartitioningSpiller {
    private static final int FIRST_PARTITION_START = -10;
    private static final int SECOND_PARTITION_START = 0;
    private static final int THIRD_PARTITION_START = 10;
    private static final int FOURTH_PARTITION_START = 20;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
    private final BlockEncodingSerde blockEncodingSerde = new BlockEncodingManager();
    private Path tempDirectory;
    private SingleStreamSpillerFactory singleStreamSpillerFactory;
    private GenericPartitioningSpillerFactory factory;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() throws Exception {
        this.tempDirectory = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setSpillerSpillPaths(this.tempDirectory.toString());
        featuresConfig.setSpillerThreads(8);
        featuresConfig.setSpillMaxUsedSpaceThreshold(1.0);
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.blockEncodingSerde, new SpillerStats(), featuresConfig, new NodeSpillConfig());
        this.factory = new GenericPartitioningSpillerFactory(this.singleStreamSpillerFactory);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        try (Closer closer = Closer.create();){
            closer.register(() -> this.scheduledExecutor.shutdownNow());
            closer.register(() -> MoreFiles.deleteRecursively((Path)this.tempDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        }
    }

    @Test
    public void testFileSpiller() throws Exception {
        try (PartitioningSpiller spiller = this.factory.create(TYPES, (PartitionFunction)new FourFixedPartitionsPartitionFunction(0), TestGenericPartitioningSpiller.mockSpillContext(), TestGenericPartitioningSpiller.mockMemoryContext(this.scheduledExecutor));){
            RowPagesBuilder builder = RowPagesBuilder.rowPagesBuilder(TYPES);
            builder.addSequencePage(10, 0, 5, 10, 15);
            builder.addSequencePage(10, -10, -5, 0, 5);
            List<Page> firstSpill = builder.build();
            builder = RowPagesBuilder.rowPagesBuilder(TYPES);
            builder.addSequencePage(10, 10, 15, 20, 25);
            builder.addSequencePage(10, 20, 25, 30, 35);
            List<Page> secondSpill = builder.build();
            IntPredicate spillPartitionMask = arg_0 -> ((ImmutableSet)ImmutableSet.of((Object)1, (Object)2)).contains(arg_0);
            PartitioningSpiller.PartitioningSpillResult result = spiller.partitionAndSpill(firstSpill.get(0), spillPartitionMask);
            result.getSpillingFuture().get();
            Assert.assertEquals((int)result.getRetained().getPositionCount(), (int)0);
            result = spiller.partitionAndSpill(firstSpill.get(1), spillPartitionMask);
            result.getSpillingFuture().get();
            Assert.assertEquals((int)result.getRetained().getPositionCount(), (int)10);
            result = spiller.partitionAndSpill(secondSpill.get(0), spillPartitionMask);
            result.getSpillingFuture().get();
            Assert.assertEquals((int)result.getRetained().getPositionCount(), (int)0);
            result = spiller.partitionAndSpill(secondSpill.get(1), spillPartitionMask);
            result.getSpillingFuture().get();
            Assert.assertEquals((int)result.getRetained().getPositionCount(), (int)10);
            builder = RowPagesBuilder.rowPagesBuilder(TYPES);
            builder.addSequencePage(10, 0, 5, 10, 15);
            List<Page> secondPartition = builder.build();
            builder = RowPagesBuilder.rowPagesBuilder(TYPES);
            builder.addSequencePage(10, 10, 15, 20, 25);
            List<Page> thirdPartition = builder.build();
            this.assertSpilledPages(TYPES, spiller, (List<List<Page>>)ImmutableList.of((Object)ImmutableList.of(), secondPartition, thirdPartition, (Object)ImmutableList.of()));
        }
    }

    @Test
    public void testCloseDuringReading() throws Exception {
        Iterator readingInProgress;
        try (PartitioningSpiller spiller = this.factory.create(TYPES, (PartitionFunction)new ModuloPartitionFunction(0, 4), TestGenericPartitioningSpiller.mockSpillContext(), TestGenericPartitioningSpiller.mockMemoryContext(this.scheduledExecutor));){
            Page page = SequencePageBuilder.createSequencePage(TYPES, 10, -10, 5, 10, 15);
            PartitioningSpiller.PartitioningSpillResult spillResult = spiller.partitionAndSpill(page, partition -> true);
            Assert.assertEquals((int)spillResult.getRetained().getPositionCount(), (int)0);
            MoreFutures.getFutureValue((Future)spillResult.getSpillingFuture());
            readingInProgress = spiller.getSpilledPages(0);
        }
        try {
            readingInProgress.hasNext();
            Assert.fail((String)"Iterator.hasNext() should fail since underlying resources are closed");
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteManyPartitions() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        int partitionCount = 4;
        AggregatedMemoryContext memoryContext = TestGenericPartitioningSpiller.mockMemoryContext(this.scheduledExecutor);
        try (GenericPartitioningSpiller spiller = (GenericPartitioningSpiller)this.factory.create((List)types, (PartitionFunction)new ModuloPartitionFunction(0, partitionCount), TestGenericPartitioningSpiller.mockSpillContext(), memoryContext);){
            for (int i = 0; i < 50000; ++i) {
                Page page = SequencePageBuilder.createSequencePage((List<? extends Type>)types, partitionCount, 0);
                PartitioningSpiller.PartitioningSpillResult spillResult = spiller.partitionAndSpill(page, partition -> true);
                Assert.assertEquals((int)spillResult.getRetained().getPositionCount(), (int)0);
                MoreFutures.getFutureValue((Future)spillResult.getSpillingFuture());
                MoreFutures.getFutureValue((Future)spiller.flush());
            }
        }
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L, (String)"Reserved bytes should be zeroed after spiller is closed");
    }

    private void assertSpilledPages(List<Type> types, PartitioningSpiller spiller, List<List<Page>> expectedPartitions) {
        for (int partition = 0; partition < expectedPartitions.size(); ++partition) {
            ImmutableList actualSpill = ImmutableList.copyOf((Iterator)spiller.getSpilledPages(partition));
            List<Page> expectedSpill = expectedPartitions.get(partition);
            Assert.assertEquals((int)actualSpill.size(), (int)expectedSpill.size());
            for (int j = 0; j < actualSpill.size(); ++j) {
                PageAssertions.assertPageEquals(types, (Page)actualSpill.get(j), expectedSpill.get(j));
            }
        }
    }

    private static AggregatedMemoryContext mockMemoryContext(ScheduledExecutorService scheduledExecutor) {
        return TestingOperatorContext.create(scheduledExecutor).aggregateSystemMemoryContext();
    }

    private static SpillContext mockSpillContext() {
        return new TestingSpillContext();
    }

    private static class ModuloPartitionFunction
    implements PartitionFunction {
        private final int valueChannel;
        private final int partitionCount;

        ModuloPartitionFunction(int valueChannel, int partitionCount) {
            this.valueChannel = valueChannel;
            Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0);
            this.partitionCount = partitionCount;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public int getPartition(Page page, int position) {
            long value = page.getBlock(this.valueChannel).getLong(position);
            return Math.toIntExact(Math.abs(value) % (long)this.partitionCount);
        }
    }

    private static class FourFixedPartitionsPartitionFunction
    implements PartitionFunction {
        private final int valueChannel;

        FourFixedPartitionsPartitionFunction(int valueChannel) {
            this.valueChannel = valueChannel;
        }

        public int getPartitionCount() {
            return 4;
        }

        public int getPartition(Page page, int position) {
            long value = page.getBlock(this.valueChannel).getLong(position);
            if (value >= 20L) {
                return 3;
            }
            if (value >= 10L) {
                return 2;
            }
            if (value >= 0L) {
                return 1;
            }
            return 0;
        }
    }
}

