/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class CommonSubExpressionBenchmark {
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR, (Object)"json", (Object)VarcharType.VARCHAR);
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final int POSITIONS = 1024;
    private PageProcessor pageProcessor;
    private CursorProcessor cursorProcessor;
    private Page inputPage;
    private Map<String, Type> symbolTypes;
    private Map<VariableReferenceExpression, Integer> sourceLayout;
    private List<Type> projectionTypes;
    @Param(value={"json", "bigint", "varchar"})
    String functionType;
    @Param(value={"true", "false"})
    boolean optimizeCommonSubExpression;
    @Param(value={"true", "false"})
    boolean dictionaryBlocks;

    @Setup
    public void setup() {
        Type type = TYPE_MAP.get(this.functionType);
        VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), type.getDisplayName().toLowerCase(Locale.ENGLISH) + "0", type);
        this.symbolTypes = ImmutableMap.of((Object)variable.getName(), (Object)type);
        this.sourceLayout = ImmutableMap.of((Object)variable, (Object)0);
        this.inputPage = CommonSubExpressionBenchmark.createPage(this.functionType, this.dictionaryBlocks);
        List<RowExpression> projections = this.getProjections(this.functionType);
        this.projectionTypes = projections.stream().map(RowExpression::getType).collect(Collectors.toList());
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler);
        this.pageProcessor = (PageProcessor)expressionCompiler.compilePageProcessor(TEST_SESSION.getSqlFunctionProperties(), Optional.of(this.getFilter(this.functionType)), projections, this.optimizeCommonSubExpression, Optional.empty()).get();
        this.cursorProcessor = (CursorProcessor)expressionCompiler.compileCursorProcessor(TEST_SESSION.getSqlFunctionProperties(), Optional.of(this.getFilter(this.functionType)), projections, (Object)"key", this.optimizeCommonSubExpression).get();
    }

    @Benchmark
    public List<Optional<Page>> computePage() {
        return ImmutableList.copyOf((Iterator)this.pageProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    @Benchmark
    public Optional<Page> ComputeRecordSet() {
        ImmutableList types = ImmutableList.of((Object)TYPE_MAP.get(this.functionType));
        PageBuilder pageBuilder = new PageBuilder(this.projectionTypes);
        PageRecordSet recordSet = new PageRecordSet((List)types, this.inputPage);
        this.cursorProcessor.process(null, new DriverYieldSignal(), recordSet.cursor(), pageBuilder);
        return Optional.of(pageBuilder.build());
    }

    private RowExpression getFilter(String functionType) {
        if (functionType.equals("varchar")) {
            return this.rowExpression("cast(varchar0 as bigint) % 2 = 0");
        }
        if (functionType.equals("bigint")) {
            return this.rowExpression("bigint0 % 2 = 0");
        }
        if (functionType.equals("json")) {
            return this.rowExpression("rand() < 0.5");
        }
        throw new IllegalArgumentException("filter not supported for type : " + functionType);
    }

    private List<RowExpression> getProjections(String functionType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (functionType.equals("bigint")) {
            return ImmutableList.of((Object)this.rowExpression("bigint0 + bigint0"), (Object)this.rowExpression("bigint0 + bigint0 + 5"));
        }
        if (functionType.equals("varchar")) {
            return ImmutableList.of((Object)this.rowExpression("concat(varchar0, varchar0)"), (Object)this.rowExpression("concat(concat(varchar0, varchar0), 'foo')"));
        }
        if (functionType.equals("json")) {
            return ImmutableList.of((Object)this.rowExpression("json_extract(json_parse(varchar0), '$.a')"), (Object)this.rowExpression("json_extract(json_parse(varchar0), '$.b')"));
        }
        throw new IllegalArgumentException();
    }

    private RowExpression rowExpression(String value) {
        Expression expression = FunctionAssertions.createExpression(value, METADATA, TypeProvider.copyOf(this.symbolTypes));
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, (TypeProvider)TypeProvider.copyOf(this.symbolTypes), (Expression)expression, Collections.emptyMap(), (WarningCollector)WarningCollector.NOOP);
        RowExpression rowExpression = SqlToRowExpressionTranslator.translate((Expression)expression, (Map)expressionTypes, this.sourceLayout, (FunctionAndTypeManager)METADATA.getFunctionAndTypeManager(), (Session)TEST_SESSION);
        RowExpressionOptimizer optimizer = new RowExpressionOptimizer(METADATA);
        return optimizer.optimize(rowExpression, ExpressionOptimizer.Level.OPTIMIZED, TEST_SESSION.toConnectorSession());
    }

    private static Page createPage(String functionType, boolean dictionary) {
        ImmutableList types = ImmutableList.of((Object)TYPE_MAP.get(functionType));
        switch (functionType) {
            case "bigint": 
            case "varchar": {
                if (dictionary) {
                    return SequencePageBuilder.createSequencePageWithDictionaryBlocks((List<? extends Type>)types, 1024);
                }
                return SequencePageBuilder.createSequencePage((List<? extends Type>)types, 1024);
            }
            case "json": {
                if (dictionary) {
                    return CommonSubExpressionBenchmark.createDictionaryStringJsonPage();
                }
                return CommonSubExpressionBenchmark.createStringJsonPage();
            }
        }
        throw new IllegalArgumentException();
    }

    private static Page createStringJsonPage() {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1024);
        for (int i = 0; i < 1024; ++i) {
            VarcharType.VARCHAR.writeString(builder, "{\"a\": 1, \"b\": 2}");
        }
        return new Page(new Block[]{builder.build()});
    }

    private static Page createDictionaryStringJsonPage() {
        int dictionarySize = 204;
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, dictionarySize);
        for (int i = 0; i < dictionarySize; ++i) {
            VarcharType.VARCHAR.writeString(builder, "{\"a\": 1, \"b\": 2}");
        }
        int[] ids = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new Page(new Block[]{new DictionaryBlock(builder.build(), ids)});
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + CommonSubExpressionBenchmark.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

