/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.CommonSubExpressionRewriter;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCommonSubExpressionRewriter {
    private static final Session SESSION = SessionTestUtils.TEST_SESSION;
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeProvider TYPES = TypeProvider.viewOf((Map)ImmutableMap.builder().put((Object)"x", (Object)BigintType.BIGINT).put((Object)"y", (Object)BigintType.BIGINT).put((Object)"z", (Object)BigintType.BIGINT).put((Object)"add$cse", (Object)BigintType.BIGINT).put((Object)"multiply$cse", (Object)BigintType.BIGINT).put((Object)"add$cse_0", (Object)BigintType.BIGINT).put((Object)"expr$cse", (Object)BigintType.BIGINT).build());

    @Test
    void testGetExpressionsWithCSE() {
        ImmutableList expressions = ImmutableList.of((Object)this.rowExpression("x + y"), (Object)this.rowExpression("(x + y) * 2"), (Object)this.rowExpression("x + 2"), (Object)this.rowExpression("y * (x + 2)"), (Object)this.rowExpression("x * y"));
        Map expressionsWithCSE = CommonSubExpressionRewriter.getExpressionsPartitionedByCSE((Collection)expressions, (int)3);
        Assert.assertEquals((Map)expressionsWithCSE, (Map)ImmutableMap.of((Object)ImmutableList.of((Object)this.rowExpression("x + y"), (Object)this.rowExpression("(x + y) * 2")), (Object)true, (Object)ImmutableList.of((Object)this.rowExpression("x + 2"), (Object)this.rowExpression("y * (x + 2)")), (Object)true, (Object)ImmutableList.of((Object)this.rowExpression("x * y")), (Object)false));
        expressions = ImmutableList.of((Object)this.rowExpression("x + y"), (Object)this.rowExpression("x * 2"), (Object)this.rowExpression("x + y + x * 2"), (Object)this.rowExpression("y * 2"), (Object)this.rowExpression("x + y * 2"));
        expressionsWithCSE = CommonSubExpressionRewriter.getExpressionsPartitionedByCSE((Collection)expressions, (int)3);
        Assert.assertEquals((Map)expressionsWithCSE, (Map)ImmutableMap.of((Object)ImmutableList.of((Object)this.rowExpression("x + y"), (Object)this.rowExpression("x + y + x * 2"), (Object)this.rowExpression("x * 2")), (Object)true, (Object)ImmutableList.of((Object)this.rowExpression("y * 2"), (Object)this.rowExpression("x + y * 2")), (Object)true));
        expressionsWithCSE = CommonSubExpressionRewriter.getExpressionsPartitionedByCSE((Collection)expressions, (int)2);
        Assert.assertEquals((Map)expressionsWithCSE, (Map)ImmutableMap.of((Object)ImmutableList.of((Object)this.rowExpression("x + y"), (Object)this.rowExpression("x + y + x * 2")), (Object)true, (Object)ImmutableList.of((Object)this.rowExpression("y * 2"), (Object)this.rowExpression("x + y * 2")), (Object)true, (Object)ImmutableList.of((Object)this.rowExpression("x * 2")), (Object)true));
    }

    @Test
    void testCollectCSEByLevel() {
        ImmutableList expressions = ImmutableList.of((Object)this.rowExpression("x * 2 + y + z"), (Object)this.rowExpression("(x * 2 + y + 1) * 2"), (Object)this.rowExpression("(x * 2)  + (x * 2 + y + z)"));
        Map cseByLevel = CommonSubExpressionRewriter.collectCSEByLevel((List)expressions);
        Assert.assertEquals((Map)cseByLevel, (Map)ImmutableMap.of((Object)3, (Object)ImmutableMap.of((Object)this.rowExpression("\"add$cse\" + z"), (Object)this.rowExpression("\"add$cse_0\"")), (Object)2, (Object)ImmutableMap.of((Object)this.rowExpression("\"multiply$cse\" + y"), (Object)this.rowExpression("\"add$cse\"")), (Object)1, (Object)ImmutableMap.of((Object)this.rowExpression("x * 2"), (Object)this.rowExpression("\"multiply$cse\""))));
    }

    @Test
    void testCollectCSEByLevelCaseStatement() {
        ImmutableList expressions = ImmutableList.of((Object)this.rowExpression("1 + CASE WHEN x = 1 THEN y + z WHEN x = 2 THEN z * 2 END"), (Object)this.rowExpression("2 + CASE WHEN x = 1 THEN y + z WHEN x = 2 THEN z * 2 END"));
        Map cseByLevel = CommonSubExpressionRewriter.collectCSEByLevel((List)expressions);
        Assert.assertEquals((Map)cseByLevel, (Map)ImmutableMap.of((Object)3, (Object)ImmutableMap.of((Object)this.rowExpression("CASE WHEN x = 1 THEN y + z WHEN x = 2 THEN z * 2 END"), (Object)this.rowExpression("\"expr$cse\""))));
    }

    @Test
    void testNoRedundantCSE() {
        ImmutableList expressions = ImmutableList.of((Object)this.rowExpression("x * 2 + y + z"), (Object)this.rowExpression("(x * 2 + y + z) * 2"), (Object)this.rowExpression("x * 2"));
        Map cseByLevel = CommonSubExpressionRewriter.collectCSEByLevel((List)expressions);
        Assert.assertEquals((Map)cseByLevel, (Map)ImmutableMap.of((Object)3, (Object)ImmutableMap.of((Object)this.rowExpression("\"multiply$cse\" + y + z"), (Object)this.rowExpression("\"add$cse\"")), (Object)1, (Object)ImmutableMap.of((Object)this.rowExpression("x * 2"), (Object)this.rowExpression("\"multiply$cse\""))));
    }

    @Test
    void testRewriteExpressionWithCSE() {
        Assert.assertEquals((Object)CommonSubExpressionRewriter.rewriteExpressionWithCSE((RowExpression)this.rowExpression("(x * y + z) * (y + z) + (x * y)"), (Map)ImmutableMap.of((Object)this.rowExpression("x * y"), (Object)this.variable("multiply$cse"), (Object)this.rowExpression("y + z"), (Object)this.variable("add$cse"), (Object)this.rowExpression("\"multiply$cse\" + z"), (Object)this.variable("add$cse_0"))), (Object)this.rowExpression("\"add$cse_0\" * \"add$cse\" + \"multiply$cse\""));
    }

    private VariableReferenceExpression variable(String variable) {
        return new VariableReferenceExpression(Optional.empty(), variable, (Type)TYPES.allTypes().get(variable));
    }

    private RowExpression rowExpression(String sql) {
        Expression expression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql));
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)SESSION, (Metadata)METADATA, (SqlParser)new SqlParser(), (TypeProvider)TYPES, (Expression)expression, (Map)ImmutableMap.of(), (WarningCollector)WarningCollector.NOOP);
        return SqlToRowExpressionTranslator.translate((Expression)expression, (Map)expressionTypes, (Map)ImmutableMap.of(), (FunctionAndTypeManager)METADATA.getFunctionAndTypeManager(), (Session)SESSION);
    }
}

