/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.gen.InCodeGenerator;
import com.facebook.presto.sql.relational.Expressions;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInCodeGenerator {
    @Test
    public void testInteger() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(Expressions.constant((Object)Integer.MIN_VALUE, (Type)IntegerType.INTEGER));
        values.add(Expressions.constant((Object)Integer.MAX_VALUE, (Type)IntegerType.INTEGER));
        values.add(Expressions.constant((Object)3L, (Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)IntegerType.INTEGER, values), (Object)InCodeGenerator.SwitchGenerationCase.DIRECT_SWITCH);
        values.add(Expressions.constant(null, (Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)IntegerType.INTEGER, values), (Object)InCodeGenerator.SwitchGenerationCase.DIRECT_SWITCH);
        values.add(new CallExpression(CastType.CAST.name(), functionAndTypeManager.lookupCast(CastType.CAST, (Type)DoubleType.DOUBLE, (Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER, Collections.singletonList(Expressions.constant((Object)1.2345678901234E13, (Type)DoubleType.DOUBLE))));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)IntegerType.INTEGER, values), (Object)InCodeGenerator.SwitchGenerationCase.DIRECT_SWITCH);
        for (int i = 6; i <= 32; ++i) {
            values.add(Expressions.constant((Object)i, (Type)IntegerType.INTEGER));
        }
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)IntegerType.INTEGER, values), (Object)InCodeGenerator.SwitchGenerationCase.DIRECT_SWITCH);
        values.add(Expressions.constant((Object)33L, (Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)IntegerType.INTEGER, values), (Object)InCodeGenerator.SwitchGenerationCase.SET_CONTAINS);
    }

    @Test
    public void testBigint() {
        FunctionAndTypeManager functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(Expressions.constant((Object)0x80000000L, (Type)BigintType.BIGINT));
        values.add(Expressions.constant((Object)-2147483649L, (Type)BigintType.BIGINT));
        values.add(Expressions.constant((Object)3L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)BigintType.BIGINT, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(Expressions.constant(null, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)BigintType.BIGINT, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(new CallExpression(CastType.CAST.name(), functionAndTypeManager.lookupCast(CastType.CAST, (Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, Collections.singletonList(Expressions.constant((Object)1.2345678901234E13, (Type)DoubleType.DOUBLE))));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)BigintType.BIGINT, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        for (long i = 6L; i <= 32L; ++i) {
            values.add(Expressions.constant((Object)i, (Type)BigintType.BIGINT));
        }
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)BigintType.BIGINT, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(Expressions.constant((Object)33L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)BigintType.BIGINT, values), (Object)InCodeGenerator.SwitchGenerationCase.SET_CONTAINS);
    }

    @Test
    public void testDate() {
        ArrayList<ConstantExpression> values = new ArrayList<ConstantExpression>();
        values.add(Expressions.constant((Object)1L, (Type)DateType.DATE));
        values.add(Expressions.constant((Object)2L, (Type)DateType.DATE));
        values.add(Expressions.constant((Object)3L, (Type)DateType.DATE));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DateType.DATE, values), (Object)InCodeGenerator.SwitchGenerationCase.DIRECT_SWITCH);
        for (long i = 4L; i <= 32L; ++i) {
            values.add(Expressions.constant((Object)i, (Type)DateType.DATE));
        }
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DateType.DATE, values), (Object)InCodeGenerator.SwitchGenerationCase.DIRECT_SWITCH);
        values.add(Expressions.constant((Object)33L, (Type)DateType.DATE));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DateType.DATE, values), (Object)InCodeGenerator.SwitchGenerationCase.SET_CONTAINS);
    }

    @Test
    public void testDouble() {
        ArrayList<ConstantExpression> values = new ArrayList<ConstantExpression>();
        values.add(Expressions.constant((Object)1.5, (Type)DoubleType.DOUBLE));
        values.add(Expressions.constant((Object)2.5, (Type)DoubleType.DOUBLE));
        values.add(Expressions.constant((Object)3.5, (Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DoubleType.DOUBLE, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(Expressions.constant(null, (Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DoubleType.DOUBLE, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        for (int i = 5; i <= 32; ++i) {
            values.add(Expressions.constant((Object)((double)i + 0.5), (Type)DoubleType.DOUBLE));
        }
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DoubleType.DOUBLE, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(Expressions.constant((Object)33.5, (Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)DoubleType.DOUBLE, values), (Object)InCodeGenerator.SwitchGenerationCase.SET_CONTAINS);
    }

    @Test
    public void testVarchar() {
        ArrayList<ConstantExpression> values = new ArrayList<ConstantExpression>();
        values.add(Expressions.constant((Object)Slices.utf8Slice((String)"1"), (Type)VarcharType.VARCHAR));
        values.add(Expressions.constant((Object)Slices.utf8Slice((String)"2"), (Type)VarcharType.VARCHAR));
        values.add(Expressions.constant((Object)Slices.utf8Slice((String)"3"), (Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)VarcharType.VARCHAR, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(Expressions.constant(null, (Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)VarcharType.VARCHAR, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        for (int i = 5; i <= 32; ++i) {
            values.add(Expressions.constant((Object)Slices.utf8Slice((String)String.valueOf(i)), (Type)VarcharType.VARCHAR));
        }
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)VarcharType.VARCHAR, values), (Object)InCodeGenerator.SwitchGenerationCase.HASH_SWITCH);
        values.add(Expressions.constant((Object)Slices.utf8Slice((String)"33"), (Type)VarcharType.VARCHAR));
        Assert.assertEquals((Object)InCodeGenerator.checkSwitchGenerationCase((Type)VarcharType.VARCHAR, values), (Object)InCodeGenerator.SwitchGenerationCase.SET_CONTAINS);
    }
}

