/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.VarArgsToArrayAdapterGenerator;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVarArgsToArrayAdapterGenerator
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalarFunction(TestVarArgsSum.VAR_ARGS_SUM);
    }

    @Test
    public void testArrayElements() {
        this.assertFunction("var_args_sum()", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("var_args_sum(1)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("var_args_sum(1, 2)", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("var_args_sum(null)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("var_args_sum(1, null, 2, null, 3)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("var_args_sum(1, 2, 3)", (Type)IntegerType.INTEGER, 6);
        int k = 100;
        int expectedSum = (1 + k) * k / 2;
        this.assertFunction(String.format("var_args_sum(%s)", Joiner.on((String)",").join((Iterable)IntStream.rangeClosed(1, k).boxed().collect(Collectors.toSet()))), (Type)IntegerType.INTEGER, expectedSum);
    }

    public static class TestVarArgsSum
    extends SqlScalarFunction {
        public static final TestVarArgsSum VAR_ARGS_SUM = new TestVarArgsSum();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(TestVarArgsSum.class, (String)"varArgsSum", (Class[])new Class[]{long[].class});

        private TestVarArgsSum() {
            super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"var_args_sum"), FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), IntegerType.INTEGER.getTypeSignature(), (List)ImmutableList.of((Object)IntegerType.INTEGER.getTypeSignature()), true));
        }

        public SqlFunctionVisibility getVisibility() {
            return SqlFunctionVisibility.PUBLIC;
        }

        public boolean isDeterministic() {
            return false;
        }

        public String getDescription() {
            return "return sum of all the parameters";
        }

        public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
            VarArgsToArrayAdapterGenerator.VarArgMethodHandle varArgMethodHandle = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Long.TYPE, Long.TYPE, (int)arity, (MethodHandle)METHOD_HANDLE);
            return new BuiltInScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementationChoice.NullConvention)ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), varArgMethodHandle.getMethodHandle());
        }

        @UsedByGeneratedCode
        public static long varArgsSum(long[] values) {
            long sum = 0L;
            for (long value : values) {
                sum += value;
            }
            return sum;
        }
    }
}

