/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.testing.InMemoryHistoryBasedPlanStatisticsProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCanonicalPlanHashes
extends BasePlanTest {
    public TestCanonicalPlanHashes() {
        super(() -> TestCanonicalPlanHashes.createTestQueryRunner());
    }

    private static LocalQueryRunner createTestQueryRunner() {
        LocalQueryRunner queryRunner = TestCanonicalPlanHashes.createQueryRunner((Map<String, String>)ImmutableMap.of());
        queryRunner.installPlugin(new Plugin(){

            public Iterable<HistoryBasedPlanStatisticsProvider> getHistoryBasedPlanStatisticsProviders() {
                return ImmutableList.of((Object)new InMemoryHistoryBasedPlanStatisticsProvider());
            }
        });
        return queryRunner;
    }

    @Test
    public void testScanFilterProject() throws Exception {
        this.assertSamePlanHash("SELECT totalprice, coalesce(orderkey, custkey) from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice, coalesce(orderkey, custkey) from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT totalprice, orderkey / 2 from orders WHERE custkey > 100 AND custkey < 120", "SELECT totalprice, orderkey / 4 from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        this.assertDifferentPlanHash("SELECT totalprice from orders WHERE custkey > 100 AND custkey < 110", "SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT totalprice from orders WHERE custkey > 100 AND custkey < 110", "SELECT totalprice from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        this.assertSamePlanHash("SELECT cast(totalprice as varchar), orderkey / 2.0 from orders WHERE custkey > 100 AND custkey < 120", "SELECT cast(totalprice as varchar), orderkey / 4.0 from orders WHERE custkey > 100 AND custkey < 120", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
    }

    @Test
    public void testGroupBy() throws Exception {
        this.assertSamePlanHash("SELECT COUNT_IF(totalprice > 0) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey, orderstatus", "SELECT COUNT_IF(totalprice > 0) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey, orderstatus", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS ((shippriority), (shippriority, custkey))", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS ((shippriority), (shippriority, custkey))", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT COUNT_IF(totalprice > 0) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey, orderstatus", "SELECT COUNT_IF(totalprice > 5) from orders WHERE custkey > 100 AND custkey < 250 GROUP BY orderkey, orderstatus", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        this.assertSamePlanHash("SELECT COUNT_IF(totalprice > 0), 1 from (select *, shippriority/2 as pri from orders) WHERE custkey > 100 AND custkey < 200 GROUP BY GROUPING SETS ((pri), (shippriority, custkey))", "SELECT COUNT_IF(totalprice > 0), 2 from (select *, shippriority/4 as pri from orders) WHERE custkey > 100 AND custkey < 200 GROUP BY GROUPING SETS ((pri), (shippriority, custkey))", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        this.assertDifferentPlanHash("SELECT COUNT(totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", "SELECT SUM(totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT COUNT(totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", "SELECT COUNT(DISTINCT totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS ((shippriority), (shippriority, custkey))", "SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY GROUPING SETS ((shippriority), (custkey))", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT COUNT(totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", "SELECT SUM(totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        this.assertDifferentPlanHash("SELECT COUNT(totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", "SELECT COUNT(DISTINCT totalprice) from orders WHERE custkey > 100 AND custkey < 200 GROUP BY orderkey", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        this.assertDifferentPlanHash("SELECT COUNT_IF(totalprice > 0) from (select *, shippriority/2 as pri from orders) WHERE custkey > 100 AND custkey < 200 GROUP BY GROUPING SETS ((pri), (shippriority, custkey))", "SELECT COUNT_IF(totalprice > 0) from (select *, shippriority/2 as pri from orders) WHERE custkey > 100 AND custkey < 250 GROUP BY GROUPING SETS ((pri), (custkey))", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
    }

    @Test
    public void testUnnest() throws Exception {
        this.assertSamePlanHash("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)", "SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3, 4] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)", "SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3, 4] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)", "SELECT a.custkey, t.e FROM (SELECT custkey, ARRAY[1, 2, 3] AS my_array FROM orders) a CROSS JOIN UNNEST(my_array) AS t(e)", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
    }

    @Test
    public void testStatsEquivalentPlanNodesMarking() {
        List<PlanNode> nodes = this.getStatsEquivalentPlanHashes("SELECT COUNT(totalprice) from orders WHERE custkey > 100 GROUP BY orderkey");
        Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof AggregationNode));
        Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof FilterNode));
        Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof ProjectNode));
        Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof TableScanNode));
        Assert.assertEquals((int)nodes.size(), (int)6);
    }

    @Test
    public void testUnion() throws Exception {
        this.assertSamePlanHash("SELECT orderkey, custkey FROM orders where orderkey < 1000 UNION ALL SELECT orderkey, custkey FROM orders where orderkey >= 1000 and orderkey < 2000 UNION ALL SELECT orderkey, custkey FROM orders where orderkey >= 2000 and orderkey < 3000", "SELECT orderkey, custkey FROM orders where orderkey >= 2000 and orderkey < 3000 UNION ALL SELECT orderkey, custkey FROM orders where orderkey < 1000 UNION ALL SELECT orderkey, custkey FROM orders where orderkey >= 1000 and orderkey < 2000", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT orderkey, custkey, 1 as x FROM orders where orderkey < 1000 UNION ALL SELECT orderkey, custkey, 1 as x FROM orders where orderkey >= 1000 and orderkey < 2000 UNION ALL SELECT orderkey, custkey, 1 as x FROM orders where orderkey >= 2000 and orderkey < 3000", "SELECT orderkey, custkey, 2 as x FROM orders where orderkey >= 2000 and orderkey < 3000 UNION ALL SELECT orderkey, custkey, 2 as x FROM orders where orderkey < 1000 UNION ALL SELECT orderkey, custkey, 2 as x FROM orders where orderkey >= 1000 and orderkey < 2000", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT orderkey, custkey, 1 as x FROM orders where orderkey < 1000 UNION ALL SELECT orderkey, custkey, 1 as x FROM orders where orderkey >= 1000 and orderkey < 2000 UNION ALL SELECT orderkey, custkey, 1 as x FROM orders where orderkey >= 2000 and orderkey < 3000", "SELECT orderkey, custkey, 2 as x FROM orders where orderkey >= 2000 and orderkey < 3000 UNION ALL SELECT orderkey, custkey, 2 as x FROM orders where orderkey < 1000 UNION ALL SELECT orderkey, custkey, 2 as x FROM orders where orderkey >= 1000 and orderkey < 2000", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
    }

    @Test
    public void testWindow() throws Exception {
        String query1 = "SELECT orderkey, SUM(custkey) OVER (PARTITION BY orderstatus ORDER BY totalprice) FROM orders where orderkey < 1000";
        String query2 = "SELECT orderkey, SUM(custkey) OVER (PARTITION BY orderstatus ORDER BY totalprice) FROM orders where orderkey < 2000";
        this.assertSamePlanHash(query1 + " UNION ALL " + query2, query2 + " UNION ALL " + query1, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query1, "SELECT orderkey, SUM(custkey) OVER (PARTITION BY totalprice ORDER BY totalprice) FROM orders where orderkey < 1000", PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testValues() throws Exception {
        String query1 = "SELECT * FROM ( VALUES (1, 'a'), (2, 'b'), (3, 'c')) AS t(id, name)";
        String query2 = "SELECT * FROM ( VALUES (1, 'a'), (2, 'b'), (3, 'c')) AS t(idd, name)";
        String query3 = "SELECT * FROM ( VALUES (1, 'a'), (3, 'b'), (2, 'c')) AS t(id, name)";
        this.assertSamePlanHash(query1, query2, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query1, query3, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testSort() throws Exception {
        String query1 = "SELECT * FROM nation where substr(name, 1, 1) = 'A' ORDER BY regionkey";
        String query2 = "SELECT * FROM nation where substr(name, 1, 1) = 'A' ORDER BY nationkey";
        this.assertSamePlanHash(query1, query1, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query1, query2, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testMarkDistinct() throws Exception {
        String query = "SELECT count(*), count(distinct orderstatus) FROM (SELECT * FROM orders WHERE orderstatus = 'F')";
        this.assertSamePlanHash(query, query, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testAssignUniqueId() throws Exception {
        String query = "SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation";
        this.assertSamePlanHash(query, query, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testEnforceSingleRow() throws Exception {
        String query = "SELECT (SELECT regionkey FROM nation WHERE name = 'nosuchvalue') AS sub";
        this.assertSamePlanHash(query, query, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testJoin() throws Exception {
        this.assertSamePlanHash("SELECT N.name, O.totalprice, C.name FROM orders O, customer C, nation N WHERE N.nationkey = C.nationkey and C.custkey = O.custkey and year(O.orderdate) = 1995", "SELECT N.name, O.totalprice, C.name FROM nation N, orders O, customer C WHERE C.nationkey = N.nationkey and C.custkey = O.custkey and year(O.orderdate) = 1995", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT O.totalprice, C.name FROM orders O JOIN customer C ON C.custkey = O.custkey WHERE year(O.orderdate) = 1995", "SELECT O.totalprice, C.name FROM customer C JOIN orders O ON C.custkey = O.custkey WHERE year(O.orderdate) = 1995", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT O.totalprice, C.name FROM orders O FULL OUTER JOIN customer C ON C.custkey = O.custkey WHERE year(O.orderdate) = 1995", "SELECT O.totalprice, C.name FROM customer C FULL OUTER JOIN orders O ON C.custkey = O.custkey WHERE year(O.orderdate) = 1995", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertSamePlanHash("SELECT O.totalprice, C.name FROM orders O LEFT JOIN customer C ON C.custkey = O.custkey and year(O.orderdate) = 1995", "SELECT O.totalprice, C.name FROM customer C RIGHT JOIN orders O ON C.custkey = O.custkey and year(O.orderdate) = 1995", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT O.totalprice, C.name FROM orders O LEFT JOIN customer C ON C.custkey = O.custkey and year(O.orderdate) = 1995", "SELECT O.totalprice, C.name FROM orders O RIGHT JOIN customer C ON C.custkey = O.custkey and year(O.orderdate) = 1995", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT * FROM orders O FULL OUTER JOIN customer C ON O.custkey = C.custkey FULL OUTER JOIN nation N ON C.nationkey = N.nationkey", "SELECT * FROM nation N FULL OUTER JOIN customer C ON C.nationkey = N.nationkey FULL OUTER JOIN orders O ON O.custkey = C.custkey", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT * FROM orders O LEFT OUTER JOIN customer C ON O.custkey = C.custkey LEFT OUTER JOIN nation N ON C.nationkey = N.nationkey", "SELECT * FROM nation N LEFT OUTER JOIN customer C ON C.nationkey = N.nationkey LEFT OUTER JOIN orders O ON O.custkey = C.custkey", PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testSemiJoin() throws Exception {
        String query = "SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 2))";
        this.assertSamePlanHash(query, query, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query, "SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 1))", PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testRowNumber() throws Exception {
        String query1 = "SELECT nationkey, ROW_NUMBER() OVER (PARTITION BY regionkey) from nation";
        String query2 = "SELECT nationkey, ROW_NUMBER() OVER (PARTITION BY name) from nation";
        this.assertSamePlanHash(query1, query1, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query1, query2, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testLimit() throws Exception {
        this.assertSamePlanHash("SELECT * from nation LIMIT 1000", "SELECT * from nation LIMIT 1000", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT * from nation LIMIT 1000", "SELECT * from nation", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT * from nation LIMIT 1000", "SELECT * from nation LIMIT 10000", PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash("SELECT * from nation LIMIT 1000", "SELECT * from nation LIMIT 10000", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
    }

    @Test
    public void testTopN() throws Exception {
        String query = "SELECT orderkey FROM orders GROUP BY 1 ORDER BY 1 DESC LIMIT 1";
        this.assertSamePlanHash(query, query, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query, "SELECT orderkey FROM orders GROUP BY 1 ORDER BY 1 DESC LIMIT 2", PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testTopNRowNumber() throws Exception {
        String query1 = "SELECT orderstatus FROM (SELECT orderstatus, row_number() OVER (PARTITION BY orderstatus ORDER BY custkey) n FROM orders) WHERE n = 1";
        String query2 = "SELECT orderstatus FROM (SELECT orderstatus, row_number() OVER (PARTITION BY orderstatus ORDER BY custkey) n FROM orders) WHERE n <= 2";
        this.assertSamePlanHash(query1, query1, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query1, query2, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testDistinctLimit() throws Exception {
        String query1 = "SELECT distinct regionkey from nation limit 2";
        String query2 = "SELECT distinct regionkey from nation limit 3";
        this.assertSamePlanHash(query1, query1, PlanCanonicalizationStrategy.CONNECTOR);
        this.assertDifferentPlanHash(query1, query2, PlanCanonicalizationStrategy.CONNECTOR);
    }

    @Test
    public void testInsert() throws Exception {
        this.assertSamePlanHash("INSERT INTO nation SELECT * from nation", "INSERT INTO nation SELECT * from nation", PlanCanonicalizationStrategy.CONNECTOR);
    }

    private Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("use_history_based_plan_statistics", "true").setSystemProperty("use_perfectly_consistent_histories", "true").setSystemProperty("task_concurrency", "1").setSystemProperty("restrict_history_based_optimization_to_complex_query", "false").build();
    }

    private void assertSamePlanHash(String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        String hashes1 = Hashing.sha256().hashString((CharSequence)this.getPlanHash(sql1, strategy), StandardCharsets.UTF_8).toString();
        String hashes2 = Hashing.sha256().hashString((CharSequence)this.getPlanHash(sql2, strategy), StandardCharsets.UTF_8).toString();
        Assert.assertEquals((String)hashes1, (String)hashes2);
    }

    private void assertDifferentPlanHash(String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        String hashes1 = Hashing.sha256().hashString((CharSequence)this.getPlanHash(sql1, strategy), StandardCharsets.UTF_8).toString();
        String hashes2 = Hashing.sha256().hashString((CharSequence)this.getPlanHash(sql2, strategy), StandardCharsets.UTF_8).toString();
        Assert.assertNotEquals((Object)hashes1, (Object)hashes2);
    }

    private List<PlanNode> getStatsEquivalentPlanHashes(String sql) {
        Session session = this.createSession();
        PlanNode root = this.plan(sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, session).getRoot();
        Assert.assertTrue((boolean)root.getStatsEquivalentPlanNode().isPresent());
        ImmutableList.Builder result = ImmutableList.builder();
        Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root).forEach(node -> node.getStatsEquivalentPlanNode().ifPresent(arg_0 -> ((ImmutableList.Builder)result).add(arg_0)));
        return result.build();
    }

    private String getPlanHash(String sql, PlanCanonicalizationStrategy strategy) throws Exception {
        Session session = this.createSession();
        PlanNode plan = this.plan(sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, session).getRoot();
        Assert.assertTrue((boolean)plan.getStatsEquivalentPlanNode().isPresent());
        return this.getObjectMapper().writeValueAsString(CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)((PlanNode)plan.getStatsEquivalentPlanNode().get()), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.getObjectMapper(), (Session)session).get());
    }
}

