/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.GroupingOperationRewriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGroupingOperationRewriter {
    private static final List<Integer> fortyIntegers = ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object)12, (Object[])new Integer[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40});

    @Test
    public void testGroupingOperationAllBitsSet() {
        ImmutableList groupingOrdinals = ImmutableList.of((Object)0, (Object)4, (Object)8);
        ImmutableList groupingSetOrdinals = ImmutableList.of((Object)ImmutableSet.of((Object)1), (Object)ImmutableSet.of((Object)7, (Object)3, (Object)1), (Object)ImmutableSet.of((Object)9, (Object)1));
        for (Set groupingSet : groupingSetOrdinals) {
            Assert.assertEquals((long)GroupingOperationRewriter.calculateGrouping((Set)groupingSet, (List)groupingOrdinals), (long)7L);
        }
    }

    @Test
    public void testGroupingOperationNoBitsSet() {
        ImmutableList groupingOrdinals = ImmutableList.of((Object)4, (Object)6);
        ImmutableList groupingSetOrdinals = ImmutableList.of((Object)ImmutableSet.of((Object)4, (Object)6));
        for (Set groupingSet : groupingSetOrdinals) {
            Assert.assertEquals((long)GroupingOperationRewriter.calculateGrouping((Set)groupingSet, (List)groupingOrdinals), (long)0L);
        }
    }

    @Test
    public void testGroupingOperationSomeBitsSet() {
        ImmutableList groupingOrdinals = ImmutableList.of((Object)7, (Object)2, (Object)9, (Object)3, (Object)5);
        ImmutableList groupingSetOrdinals = ImmutableList.of((Object)ImmutableSet.of((Object)4, (Object)2), (Object)ImmutableSet.of((Object)9, (Object)7, (Object)14), (Object)ImmutableSet.of((Object)5, (Object)2, (Object)7), (Object)ImmutableSet.of((Object)3));
        ImmutableList expectedResults = ImmutableList.of((Object)23L, (Object)11L, (Object)6L, (Object)29L);
        for (int groupId = 0; groupId < groupingSetOrdinals.size(); ++groupId) {
            Set groupingSet = (Set)groupingSetOrdinals.get(groupId);
            Assert.assertEquals((Object)GroupingOperationRewriter.calculateGrouping((Set)groupingSet, (List)groupingOrdinals), expectedResults.get(groupId));
        }
    }

    @Test
    public void testMoreThanThirtyTwoArguments() {
        ImmutableList groupingSetOrdinals = ImmutableList.of((Object)ImmutableSet.of((Object)20, (Object)2, (Object)13, (Object)33, (Object)40, (Object)9, (Object[])new Integer[]{14}), (Object)ImmutableSet.of((Object)28, (Object)4, (Object)5, (Object)29, (Object)31, (Object)10, (Object[])new Integer[0]));
        ImmutableList expectedResults = ImmutableList.of((Object)822283861886L, (Object)995358664191L);
        for (int groupId = 0; groupId < groupingSetOrdinals.size(); ++groupId) {
            Set groupingSet = (Set)groupingSetOrdinals.get(groupId);
            Assert.assertEquals((Object)GroupingOperationRewriter.calculateGrouping((Set)groupingSet, fortyIntegers), expectedResults.get(groupId));
        }
    }
}

