/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestInequalityInferenceInJoins
extends BasePlanTest {
    public TestInequalityInferenceInJoins() {
        super((Map<String, String>)ImmutableMap.of((Object)"infer_inequality_predicates", (Object)Boolean.toString(true)));
    }

    @Test
    public void testSimpleInequalityInferencesForInnerJoins() {
        String query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice > c.acctbal and c.acctbal > 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey_0", "custkey")), Optional.of("(totalprice) > (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice >= c.acctbal and c.acctbal > 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey_0", "custkey")), Optional.of("(totalprice) >= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice >= c.acctbal and c.acctbal >= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey_0", "custkey")), Optional.of("(totalprice) >= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) >= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) >= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice > c.acctbal and c.acctbal >= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey_0", "custkey")), Optional.of("(totalprice) > (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) >= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice < c.acctbal and c.acctbal < 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) < (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice <= c.acctbal and c.acctbal < 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) <= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice <= c.acctbal and c.acctbal <= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) <= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) <= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) <= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice < c.acctbal and c.acctbal <= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) < (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) <= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c, orders o where o.custkey=c.custkey and o.totalprice < c.acctbal and c.acctbal <= random()";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("((acctbal) <= (random())) AND ((totalprice) < (acctbal))"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey")))))));
    }

    @Test
    public void testSimpleInequalityInferencesForOuterJoins() {
        String query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice > c.acctbal where c.acctbal > 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) > (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice >= c.acctbal where c.acctbal > 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) >= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice >= c.acctbal where c.acctbal >= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) >= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) >= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) >= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice > c.acctbal where c.acctbal >= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) > (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) >= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) > (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice < c.acctbal where c.acctbal < 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) < (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice <= c.acctbal where c.acctbal < 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) <= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice <= c.acctbal where c.acctbal <= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) <= (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) <= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) <= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice < c.acctbal where c.acctbal <= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) < (acctbal)"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(acctbal) <= (DOUBLE'1000.0')", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice < c.acctbal and c.acctbal <= 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("((totalprice) < (acctbal)) AND ((acctbal) <= (DOUBLE'1000.0'))"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice < c.acctbal and o.totalprice < 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) < (acctbal)"), PlanMatchPattern.project(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from customer c left join orders o on o.custkey=c.custkey and o.totalprice < c.acctbal where o.totalprice < 1000";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("(totalprice) < (acctbal)"), PlanMatchPattern.project(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"acctbal", (Object)"acctbal"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("(totalprice) < (DOUBLE'1000.0')", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey_0", (Object)"custkey"))))))));
    }

    @Test
    public void testInequalityInferencesForExpressions() {
        String query = "select count(*) from orders o, customer c where o.custkey=c.custkey and o.orderkey + o.custkey <= c.nationkey and 100 <= o.orderkey + o.custkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("orderkey + custkey <= nationkey"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("BIGINT '100' <= orderkey+custkey", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("nationkey >= BIGINT '100'", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey_0", (Object)"custkey", (Object)"nationkey", (Object)"nationkey"))))))));
        query = "select count(*) from orders o left join customer c on o.custkey=c.custkey and o.orderkey + o.custkey <= c.nationkey where 100 <= o.orderkey + o.custkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("orderkey + custkey <= nationkey"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("BIGINT '100' <= orderkey+custkey", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("nationkey >= BIGINT '100'", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey_0", (Object)"custkey", (Object)"nationkey", (Object)"nationkey"))))))));
        query = "select count(*) from customer c right join orders o on o.custkey=c.custkey and o.orderkey + o.custkey <= c.nationkey where 100 <= o.orderkey + o.custkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.RIGHT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("orderkey + custkey_0 <= nationkey"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("nationkey >= BIGINT '100'", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("BIGINT '100' <= orderkey+custkey_0", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey_0", (Object)"custkey"))))))));
        query = "select count(*) from orders o, customer c where o.custkey=c.custkey and o.orderkey + o.custkey <= c.nationkey and 100 <= o.custkey + o.orderkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("orderkey + custkey <= nationkey"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("BIGINT '100' <= custkey + orderkey", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("nationkey >= BIGINT'100'", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey_0", (Object)"custkey", (Object)"nationkey", (Object)"nationkey"))))))));
        query = "select name, address, c.custkey from customer c left join orders o on c.custkey=o.custkey and c.custkey < o.orderkey + c.nationkey where 1000 < c.custkey";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("custkey < orderkey + nationkey"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("custkey > BIGINT'1000'", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"custkey", (Object)"custkey", (Object)"nationkey", (Object)"nationkey", (Object)"address", (Object)"address")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("custkey_0 > BIGINT'1000'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey_0", (Object)"custkey")))))));
        query = "select o.totalprice, o.comment, sq.name, sq.quantity from orders o left join (select * from customer c left join lineitem l on c.custkey=l.suppkey and c.custkey < l.partkey) sq on o.custkey=sq.custkey and o.orderkey <= sq.custkey where o.orderkey > 100";
        this.assertPlan(query, PlanMatchPattern.output(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey", "custkey_0")), Optional.of("orderkey <= custkey_0"), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey > BIGINT'100'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice", (Object)"custkey", (Object)"custkey", (Object)"comment", (Object)"comment", (Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("custkey_0", "suppkey")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("custkey_0 > BIGINT'100'", PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey_0", (Object)"custkey", (Object)"name", (Object)"name")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("partkey > BIGINT'100' AND suppkey > BIGINT'100' AND suppkey < partkey", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"suppkey", (Object)"suppkey", (Object)"partkey", (Object)"partkey", (Object)"quantity", (Object)"quantity")))))))));
    }
}

