/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRowExpressionRewriter {
    private FunctionAndTypeManager functionAndTypeManager;

    @BeforeClass
    public void setup() {
        this.functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    }

    @Test
    public void testSimple() {
        CallExpression predicate = Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)this.functionAndTypeManager.resolveOperator(OperatorType.GREATER_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)BigintType.BIGINT), Expressions.constant((Object)2L, (Type)BigintType.BIGINT)});
        RowExpression negatedPredicate = NegationExpressionRewriter.rewrite((RowExpression)predicate);
        Assert.assertEquals((Object)negatedPredicate.getType(), (Object)BooleanType.BOOLEAN);
        Assert.assertTrue((boolean)(negatedPredicate instanceof CallExpression));
        Assert.assertTrue((boolean)(((CallExpression)negatedPredicate).getArguments().get(0) instanceof CallExpression));
        Assert.assertEquals((String)((CallExpression)negatedPredicate).getDisplayName(), (String)"not");
        Assert.assertEquals((String)((CallExpression)((CallExpression)negatedPredicate).getArguments().get(0)).getDisplayName(), (String)OperatorType.GREATER_THAN.name());
        CallExpression nonPredicate = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)this.functionAndTypeManager.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)BigintType.BIGINT), Expressions.constant((Object)2L, (Type)BigintType.BIGINT)});
        RowExpression samePredicate = NegationExpressionRewriter.rewrite((RowExpression)nonPredicate);
        Assert.assertEquals((Object)samePredicate, (Object)nonPredicate);
    }

    @Test
    public void testInliner() {
        CallExpression predicate = Expressions.call((String)OperatorType.GREATER_THAN.name(), (FunctionHandle)this.functionAndTypeManager.resolveOperator(OperatorType.GREATER_THAN, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)BigintType.BIGINT), Expressions.constant((Object)2L, (Type)BigintType.BIGINT)});
        CallExpression nonPredicate = Expressions.call((String)OperatorType.ADD.name(), (FunctionHandle)this.functionAndTypeManager.resolveOperator(OperatorType.ADD, TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.constant((Object)1L, (Type)BigintType.BIGINT), Expressions.constant((Object)2L, (Type)BigintType.BIGINT)});
        RowExpression samePredicate = RowExpressionNodeInliner.replaceExpression((RowExpression)predicate, (Map)ImmutableMap.of((Object)predicate, (Object)nonPredicate));
        Assert.assertEquals((Object)samePredicate, (Object)nonPredicate);
    }

    public static class NegationExpressionRewriter {
        private NegationExpressionRewriter() {
        }

        public static RowExpression rewrite(RowExpression expression) {
            return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new Visitor(), (RowExpression)expression);
        }

        private static class Visitor
        extends RowExpressionRewriter<Void> {
            private final FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            private final StandardFunctionResolution functionResolution = new FunctionResolution(this.functionAndTypeManager.getFunctionAndTypeResolver());

            Visitor() {
            }

            public RowExpression rewriteCall(CallExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
                FunctionMetadata metadata = this.functionAndTypeManager.getFunctionMetadata(node.getFunctionHandle());
                if (metadata.getOperatorType().isPresent() && ((OperatorType)metadata.getOperatorType().get()).isComparisonOperator()) {
                    return Expressions.call((String)"not", (FunctionHandle)this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{node});
                }
                return null;
            }
        }
    }
}

