/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.RowExpressionVerifier;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DynamicFilterMatcher
implements Matcher {
    private final Map<SymbolAlias, SymbolAlias> expectedDynamicFilters;
    private final Map<String, String> joinExpectedMappings;
    private final Map<String, String> filterExpectedMappings;
    private final Optional<Expression> expectedStaticFilter;
    private JoinNode joinNode;
    private SymbolAliases symbolAliases;
    private FilterNode filterNode;

    public DynamicFilterMatcher(Map<SymbolAlias, SymbolAlias> expectedDynamicFilters, Optional<Expression> expectedStaticFilter) {
        this.expectedDynamicFilters = Objects.requireNonNull(expectedDynamicFilters, "expectedDynamicFilters is null");
        this.joinExpectedMappings = (Map)expectedDynamicFilters.values().stream().collect(ImmutableMap.toImmutableMap(rightSymbol -> rightSymbol.toString() + "_alias", SymbolAlias::toString));
        this.filterExpectedMappings = (Map)expectedDynamicFilters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toString(), entry -> ((SymbolAlias)entry.getValue()).toString() + "_alias"));
        this.expectedStaticFilter = Objects.requireNonNull(expectedStaticFilter, "expectedStaticFilter is null");
    }

    public MatchResult match(JoinNode joinNode, SymbolAliases symbolAliases) {
        Preconditions.checkState((this.joinNode == null ? 1 : 0) != 0, (Object)"joinNode must be null at this point");
        this.joinNode = joinNode;
        this.symbolAliases = symbolAliases;
        return new MatchResult(this.match());
    }

    private MatchResult match(FilterNode filterNode, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((this.filterNode == null ? 1 : 0) != 0, (Object)"filterNode must be null at this point");
        this.filterNode = filterNode;
        this.symbolAliases = symbolAliases;
        LogicalRowExpressions logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(metadata.getFunctionAndTypeManager()), (StandardFunctionResolution)new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()), (FunctionMetadataManager)metadata.getFunctionAndTypeManager());
        boolean staticFilterMatches = this.expectedStaticFilter.map(filter -> {
            RowExpressionVerifier verifier = new RowExpressionVerifier(symbolAliases, metadata, session);
            RowExpression staticFilter = logicalRowExpressions.combineConjuncts((Collection)DynamicFilters.extractDynamicFilters((RowExpression)filterNode.getPredicate()).getStaticConjuncts());
            return (Boolean)verifier.process((Node)filter, staticFilter);
        }).orElse(true);
        return new MatchResult(this.match() && staticFilterMatches);
    }

    private boolean match() {
        Preconditions.checkState((this.symbolAliases != null ? 1 : 0) != 0, (Object)"symbolAliases is null");
        if (this.filterNode == null || this.joinNode == null) {
            return true;
        }
        Map idToProbeSymbolMap = (Map)DynamicFilters.extractDynamicFilters((RowExpression)this.filterNode.getPredicate()).getDynamicConjuncts().stream().collect(ImmutableMap.toImmutableMap(DynamicFilters.DynamicFilterPlaceholder::getId, filter -> (VariableReferenceExpression)filter.getInput()));
        Map idToBuildSymbolMap = this.joinNode.getDynamicFilters();
        if (idToProbeSymbolMap == null) {
            return false;
        }
        if (idToProbeSymbolMap.size() != this.expectedDynamicFilters.size()) {
            return false;
        }
        HashMap<Symbol, Symbol> actual = new HashMap<Symbol, Symbol>();
        for (Map.Entry idToProbeSymbol : idToProbeSymbolMap.entrySet()) {
            String id = (String)idToProbeSymbol.getKey();
            VariableReferenceExpression probe = (VariableReferenceExpression)idToProbeSymbol.getValue();
            VariableReferenceExpression build = (VariableReferenceExpression)idToBuildSymbolMap.get(id);
            if (build == null) {
                return false;
            }
            actual.put(new Symbol(probe.getName()), new Symbol(build.getName()));
        }
        Map expected = (Map)this.expectedDynamicFilters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toSymbol(this.symbolAliases), entry -> ((SymbolAlias)entry.getValue()).toSymbol(this.symbolAliases)));
        return expected.equals(actual);
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof FilterNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof FilterNode)) {
            return new MatchResult(false);
        }
        return this.match((FilterNode)node, session, metadata, symbolAliases);
    }

    public Map<String, String> getJoinExpectedMappings() {
        return this.joinExpectedMappings;
    }

    public String toString() {
        String predicate = Joiner.on((String)" AND ").join((Iterable)this.filterExpectedMappings.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(ImmutableList.toImmutableList()));
        return MoreObjects.toStringHelper((Object)this).add("dynamicPredicate", (Object)predicate).add("staticPredicate", this.expectedStaticFilter).toString();
    }
}

