/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.MatchResult;
import com.facebook.presto.sql.planner.assertions.Matcher;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.google.common.base.Preconditions;

public class OffsetMatcher
implements Matcher {
    private final long rowCount;

    public OffsetMatcher(long rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof OffsetNode)) {
            return false;
        }
        OffsetNode offsetNode = (OffsetNode)node;
        return offsetNode.getCount() == this.rowCount;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        return MatchResult.match();
    }
}

