/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin;
import com.facebook.presto.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.testng.Assert;

public class OptimizerAssert {
    private final Metadata metadata;
    private final RuleAssert.TestingStatsCalculator statsCalculator;
    private final PlanOptimizer optimizer;
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final LocalQueryRunner queryRunner;
    private Session session;
    private TypeProvider types;
    private PlanNode plan;

    public OptimizerAssert(Metadata metadata, LocalQueryRunner queryRunner, StatsCalculator statsCalculator, Session session, PlanOptimizer optimizer, TransactionManager transactionManager, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = new RuleAssert.TestingStatsCalculator(Objects.requireNonNull(statsCalculator, "statsCalculator is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.optimizer = Objects.requireNonNull(optimizer, "optimizer is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "access control is null");
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner is null");
    }

    public OptimizerAssert setSystemProperty(String key, String value) {
        return this.withSession(Session.builder((Session)this.session).setSystemProperty(key, value).build());
    }

    public OptimizerAssert withSession(Session session) {
        this.session = session;
        return this;
    }

    public OptimizerAssert on(Function<PlanBuilder, PlanNode> planProvider) {
        Preconditions.checkState((this.plan == null ? 1 : 0) != 0, (Object)"plan has already been set");
        PlanBuilder builder = new PlanBuilder(this.session, this.idAllocator, this.metadata);
        this.plan = planProvider.apply(builder);
        this.types = builder.getTypes();
        return this;
    }

    public OptimizerAssert on(String sql) {
        Preconditions.checkState((this.plan == null ? 1 : 0) != 0, (Object)"plan has already been set");
        Plan result = (Plan)this.queryRunner.inTransaction(session -> this.queryRunner.createPlan(session, sql, this.getMinimalOptimizers(), Optimizer.PlanStage.OPTIMIZED, WarningCollector.NOOP));
        this.plan = result.getRoot();
        this.types = result.getTypes();
        return this;
    }

    public void matches(PlanMatchPattern pattern) {
        this.inTransaction(session -> {
            PlanAssert.assertPlan(session, this.metadata, this.statsCalculator, this.applyRules(), pattern);
            return null;
        });
    }

    public void doesNotMatch(PlanMatchPattern pattern) {
        this.inTransaction(session -> {
            PlanAssert.assertPlanDoesNotMatch(session, this.metadata, this.statsCalculator, this.applyRules(), pattern);
            return null;
        });
    }

    public void validates(Consumer<Plan> planValidator) {
        planValidator.accept(this.applyRules());
    }

    private Plan applyRules() {
        PlanNode actual = this.optimizer.optimize(this.plan, this.session, this.types, new VariableAllocator(), this.idAllocator, WarningCollector.NOOP).getPlanNode();
        if (!ImmutableSet.copyOf((Collection)this.plan.getOutputVariables()).equals((Object)ImmutableSet.copyOf((Collection)actual.getOutputVariables()))) {
            Assert.fail((String)String.format("%s: output schema of transformed and original plans are not equivalent\n\texpected: %s\n\tactual:   %s", this.optimizer.getClass().getName(), this.plan.getOutputVariables(), actual.getOutputVariables()));
        }
        return new Plan(actual, this.types, StatsAndCosts.empty());
    }

    private List<PlanOptimizer> getMinimalOptimizers() {
        ImmutableSet.Builder rulesBuilder = ImmutableSet.builder();
        rulesBuilder.add((Object)new TransformUncorrelatedInPredicateSubqueryToDistinctInnerJoin());
        rulesBuilder.add((Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin());
        rulesBuilder.add((Object)new RemoveRedundantIdentityProjections());
        ImmutableSet rules = rulesBuilder.build();
        return ImmutableList.of((Object)new UnaliasSymbolReferences(this.queryRunner.getMetadata().getFunctionAndTypeManager()), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(this.queryRunner.getMetadata(), new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)rules), (Object)new IterativeOptimizer(this.queryRunner.getMetadata(), new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), new SimplifyRowExpressions(this.metadata).rules()));
    }

    private <T> void inTransaction(Function<Session, T> transactionSessionConsumer) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }
}

