/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.assertions;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.SymbolAlias;
import com.facebook.presto.sql.planner.assertions.SymbolAliases;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SpecificationProvider
implements ExpectedValueProvider<WindowNode.Specification> {
    private final List<SymbolAlias> partitionBy;
    private final List<SymbolAlias> orderBy;
    private final Map<SymbolAlias, SortOrder> orderings;

    SpecificationProvider(List<SymbolAlias> partitionBy, List<SymbolAlias> orderBy, Map<SymbolAlias, SortOrder> orderings) {
        this.partitionBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionBy, "partitionBy is null"));
        this.orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
        this.orderings = ImmutableMap.copyOf(Objects.requireNonNull(orderings, "orderings is null"));
    }

    @Override
    public WindowNode.Specification getExpectedValue(SymbolAliases aliases) {
        Optional<Object> orderingScheme = Optional.empty();
        if (!this.orderBy.isEmpty()) {
            orderingScheme = Optional.of(new OrderingScheme((List)this.orderings.entrySet().stream().map(entry -> new Ordering(new VariableReferenceExpression(Optional.empty(), ((SymbolAlias)entry.getKey()).toSymbol(aliases).getName(), (Type)UnknownType.UNKNOWN), (SortOrder)entry.getValue())).collect(ImmutableList.toImmutableList())));
        }
        return new WindowNode.Specification((List)this.partitionBy.stream().map(alias -> new VariableReferenceExpression(Optional.empty(), alias.toSymbol(aliases).getName(), (Type)UnknownType.UNKNOWN)).collect(ImmutableList.toImmutableList()), orderingScheme);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("orderings", this.orderings).toString();
    }

    public static boolean matchSpecification(WindowNode.Specification actual, WindowNode.Specification expected) {
        return ((ImmutableList)actual.getPartitionBy().stream().map(VariableReferenceExpression::getName).collect(ImmutableList.toImmutableList())).equals(expected.getPartitionBy().stream().map(VariableReferenceExpression::getName).collect(ImmutableList.toImmutableList())) && actual.getOrderingScheme().map(orderingScheme -> ((ImmutableSet)orderingScheme.getOrderByVariables().stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet())).equals(((OrderingScheme)expected.getOrderingScheme().get()).getOrderByVariables().stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet())) && ((ImmutableMap)orderingScheme.getOrderingsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((VariableReferenceExpression)entry.getKey()).getName(), Map.Entry::getValue))).equals(((OrderingScheme)expected.getOrderingScheme().get()).getOrderingsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((VariableReferenceExpression)entry.getKey()).getName(), Map.Entry::getValue)))).orElse(true) != false;
    }

    public static boolean matchSpecification(WindowNode.Specification actual, SpecificationProvider expected) {
        return ((ImmutableList)actual.getPartitionBy().stream().map(VariableReferenceExpression::getName).collect(ImmutableList.toImmutableList())).equals(expected.partitionBy.stream().map(SymbolAlias::toString).collect(ImmutableList.toImmutableList())) && actual.getOrderingScheme().map(orderingScheme -> ((ImmutableSet)orderingScheme.getOrderByVariables().stream().map(VariableReferenceExpression::getName).collect(ImmutableSet.toImmutableSet())).equals(expected.orderBy.stream().map(SymbolAlias::toString).collect(ImmutableSet.toImmutableSet())) && ((ImmutableMap)orderingScheme.getOrderingsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((VariableReferenceExpression)entry.getKey()).getName(), Map.Entry::getValue))).equals(expected.orderings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toString(), Map.Entry::getValue)))).orElse(true) != false;
    }
}

