/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.assertions.RowNumberSymbolMatcher;
import com.facebook.presto.sql.planner.assertions.RvalueMatcher;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ImplementOffset;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestImplementOffset
extends BaseRuleTest {
    public TestImplementOffset() {
        super(new Plugin[0]);
    }

    @Test
    public void testReplaceOffsetOverValues() {
        this.tester().assertThat((Rule)new ImplementOffset(this.getFunctionManager())).setSystemProperty("offset_clause_enabled", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            return p.offset(2L, (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)new ExpressionMatcher("a"), (Object)"b", (Object)new ExpressionMatcher("b")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.values("a", "b")).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Offset support is not enabled")
    public void testOffsetClauseDisabled() {
        this.tester().assertThat((Rule)new ImplementOffset(this.getFunctionManager())).on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            return p.offset(2L, (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)new ExpressionMatcher("a"), (Object)"b", (Object)new ExpressionMatcher("b")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.values("a", "b")).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testReplaceOffsetOverSort() {
        this.tester().assertThat((Rule)new ImplementOffset(this.getFunctionManager())).setSystemProperty("offset_clause_enabled", "true").on(p -> {
            VariableReferenceExpression a = p.variable("a");
            VariableReferenceExpression b = p.variable("b");
            return p.offset(2L, (PlanNode)p.sort((List<VariableReferenceExpression>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)new ExpressionMatcher("a"), (Object)"b", (Object)new ExpressionMatcher("b")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }
}

