/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.InlineProjections;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestInlineProjections
extends BaseRuleTest {
    public TestInlineProjections() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule)new InlineProjections(this.getFunctionManager())).on(p -> p.project((PlanNode)p.project((PlanNode)p.values(p.variable("x")), Assignments.builder().put(p.variable("symbol"), p.rowExpression("x")).put(p.variable("complex"), p.rowExpression("x * 2")).put(p.variable("literal"), p.rowExpression("1")).put(p.variable("complex_2"), p.rowExpression("x - 1")).build()), Assignments.builder().put(p.variable("identity"), p.rowExpression("symbol")).put(p.variable("multi_complex_1"), p.rowExpression("complex + 1")).put(p.variable("multi_complex_2"), p.rowExpression("complex + 2")).put(p.variable("multi_literal_1"), p.rowExpression("literal + 1")).put(p.variable("multi_literal_2"), p.rowExpression("literal + 2")).put(p.variable("single_complex"), p.rowExpression("complex_2 + 2")).put(p.variable("try"), p.rowExpression("try(complex / literal)")).build())).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression("x")).put((Object)"out2", (Object)PlanMatchPattern.expression("y + 1")).put((Object)"out3", (Object)PlanMatchPattern.expression("y + 2")).put((Object)"out4", (Object)PlanMatchPattern.expression("1 + 1")).put((Object)"out5", (Object)PlanMatchPattern.expression("1 + 2")).put((Object)"out6", (Object)PlanMatchPattern.expression("x - 1 + 2")).put((Object)"out7", (Object)PlanMatchPattern.expression("try(y / 1)")).build(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x"), (Object)"y", (Object)PlanMatchPattern.expression("x * 2")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0)))));
    }

    @Test
    public void testRowExpression() {
        this.tester().assertThat((Rule)new InlineProjections(this.getFunctionManager())).on(p -> {
            p.variable("symbol");
            p.variable("complex");
            p.variable("literal");
            p.variable("complex_2");
            p.variable("x");
            return p.project(Assignments.builder().put(p.variable("identity"), p.rowExpression("symbol")).put(p.variable("multi_complex_1"), p.rowExpression("complex + 1")).put(p.variable("multi_complex_2"), p.rowExpression("complex + 2")).put(p.variable("multi_literal_1"), p.rowExpression("literal + 1")).put(p.variable("multi_literal_2"), p.rowExpression("literal + 2")).put(p.variable("single_complex"), p.rowExpression("complex_2 + 2")).build(), (PlanNode)p.project(Assignments.builder().put(p.variable("symbol"), p.rowExpression("x")).put(p.variable("complex"), p.rowExpression("x * 2")).put(p.variable("literal"), p.rowExpression("1")).put(p.variable("complex_2"), p.rowExpression("x - 1")).build(), (PlanNode)p.values(p.variable("x"))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression("x")).put((Object)"out2", (Object)PlanMatchPattern.expression("y + 1")).put((Object)"out3", (Object)PlanMatchPattern.expression("y + 2")).put((Object)"out4", (Object)PlanMatchPattern.expression("1 + 1")).put((Object)"out5", (Object)PlanMatchPattern.expression("1 + 2")).put((Object)"out6", (Object)PlanMatchPattern.expression("x - 1 + 2")).build(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x"), (Object)"y", (Object)PlanMatchPattern.expression("x * 2")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0)))));
    }

    @Test
    public void testIdentityProjections() {
        this.tester().assertThat((Rule)new InlineProjections(this.getFunctionManager())).on(p -> p.project(PlanBuilder.assignment(p.variable("output"), (RowExpression)p.variable("value")), (PlanNode)p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{p.variable("value")}), (PlanNode)p.values(p.variable("value"))))).doesNotFire();
    }

    @Test
    public void testSubqueryProjections() {
        this.tester().assertThat((Rule)new InlineProjections(this.getFunctionManager())).on(p -> p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{p.variable("fromOuterScope"), p.variable("value")}), (PlanNode)p.project(AssignmentUtils.identityAssignments((VariableReferenceExpression[])new VariableReferenceExpression[]{p.variable("value")}), (PlanNode)p.values(p.variable("value"))))).doesNotFire();
    }
}

