/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.MergeDuplicateAggregation;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestMergeDuplicateAggregation
extends BaseRuleTest {
    public TestMergeDuplicateAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testMergeIdenticalAggregations() {
        this.tester().assertThat((Rule)new MergeDuplicateAggregation(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("merge_duplicate_aggregations", "true").on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("sum_1"), p.rowExpression("sum(col)")).addAggregation(p.variable("sum_2"), p.rowExpression("sum(col)")).source((PlanNode)p.values(p.variable("col")));
        })).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_2", (Object)PlanMatchPattern.expression("sum_1")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"col"))), PlanMatchPattern.values("col"))));
    }

    @Test
    public void testNotMergeAggregationsDifferentColumn() {
        this.tester().assertThat((Rule)new MergeDuplicateAggregation(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("merge_duplicate_aggregations", "true").on(p -> p.aggregation(af -> {
            p.variable("col1", (Type)BigintType.BIGINT);
            p.variable("col2", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("sum_1"), p.rowExpression("sum(col1)")).addAggregation(p.variable("sum_2"), p.rowExpression("sum(col2)")).source((PlanNode)p.values(p.variable("col1"), p.variable("col2")));
        })).doesNotFire();
    }

    @Test
    public void testNotMergeAggregationsDifferentFunction() {
        this.tester().assertThat((Rule)new MergeDuplicateAggregation(this.getMetadata().getFunctionAndTypeManager())).setSystemProperty("merge_duplicate_aggregations", "true").on(p -> p.aggregation(af -> {
            p.variable("col", (Type)BigintType.BIGINT);
            af.globalGrouping().addAggregation(p.variable("sum"), p.rowExpression("sum(col)")).addAggregation(p.variable("count"), p.rowExpression("count(col)")).source((PlanNode)p.values(p.variable("col")));
        })).doesNotFire();
    }
}

