/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.MergeFilters;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMergeFilters
extends BaseRuleTest {
    private TestingRowExpressionTranslator sqlToRowExpressionTranslator;

    public TestMergeFilters() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setupTranslator() {
        this.sqlToRowExpressionTranslator = new TestingRowExpressionTranslator(this.tester().getMetadata());
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule)new MergeFilters(this.getFunctionManager())).on(p -> p.filter(this.sqlToRowExpression("b > 44"), (PlanNode)p.filter(this.sqlToRowExpression("a < 42"), (PlanNode)p.values(p.variable("a"), p.variable("b"))))).matches(PlanMatchPattern.filter("(a < 42) AND (b > 44)", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))));
    }

    private RowExpression sqlToRowExpression(String sql) {
        return this.sqlToRowExpressionTranslator.translate(PlanBuilder.expression(sql), TypeProvider.copyOf((Map)ImmutableMap.of((Object)"a", (Object)BigintType.BIGINT, (Object)"b", (Object)BigintType.BIGINT)));
    }
}

