/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPickTableLayout
extends BaseRuleTest {
    private PickTableLayout pickTableLayout;
    private TableHandle nationTableHandle;
    private TableHandle ordersTableHandle;
    private ConnectorId connectorId;

    public TestPickTableLayout() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setUpBeforeClass() {
        this.pickTableLayout = new PickTableLayout(this.tester().getMetadata());
        this.connectorId = this.tester().getCurrentConnectorId();
        TpchTableHandle nationTpchTableHandle = new TpchTableHandle("nation", 1.0);
        TpchTableHandle orderTpchTableHandle = new TpchTableHandle("orders", 1.0);
        this.nationTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)nationTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(nationTpchTableHandle, TupleDomain.all())));
        this.ordersTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)orderTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(orderTpchTableHandle, TupleDomain.all())));
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        for (Rule rule : this.pickTableLayout.rules()) {
            this.tester().assertThat(rule).on(p -> p.values(p.variable("a", (Type)BigintType.BIGINT))).doesNotFire();
        }
    }

    @Test
    public void doesNotFireIfTableScanHasTableLayout() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutWithoutPredicate()).on(p -> p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)))).doesNotFire();
    }

    @Test
    public void eliminateTableScanWhenNoLayoutExist() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
            return p.filter(p.rowExpression("orderstatus = 'G'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))));
        }).matches(PlanMatchPattern.values("A"));
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
            return p.filter(p.rowExpression("orderstatus = 'G'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))));
        }).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void replaceWithExistsWhenNoLayoutExist() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$replaceWithExistsWhenNoLayoutExist$4((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.values("A"));
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$replaceWithExistsWhenNoLayoutExist$5((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void doesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("nationkey", (Type)BigintType.BIGINT);
            return p.filter(p.rowExpression("nationkey % 17 =  BIGINT '44' AND nationkey % 15 =  BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all()));
        }).doesNotFire();
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("nationkey");
            return p.filter(p.rowExpression("nationkey % 17 =  BIGINT '44' AND nationkey % 15 =  BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all()));
        }).doesNotFire();
    }

    @Test
    public void ruleAddedTableLayoutToTableScan() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutWithoutPredicate()).on(p -> p.tableScan(new TableHandle(this.connectorId, (ConnectorTableHandle)new TpchTableHandle("nation", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)))).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void ruleAddedTableLayoutToFilterTableScan() {
        ImmutableMap filterConstraint = ImmutableMap.builder().put((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))).build();
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
            return p.filter(p.rowExpression("orderstatus = CAST ('F' AS VARCHAR(1))"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))));
        }).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
            return p.filter(p.rowExpression("orderstatus = CAST ('F' AS VARCHAR(1))"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))));
        }).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void ruleAddedNewTableLayoutIfTableScanHasEmptyConstraint() {
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
            return p.filter(p.rowExpression("orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))));
        }).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(p -> {
            p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
            return p.filter(p.rowExpression("orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))));
        }).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void ruleWithPushdownableToTableLayoutPredicate() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$ruleWithPushdownableToTableLayoutPredicate$13((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$ruleWithPushdownableToTableLayoutPredicate$14((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void nonDeterministicPredicate() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$nonDeterministicPredicate$15((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.filter("rand() = 0", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))));
        this.tester().assertThat((Rule)this.pickTableLayout.pickTableLayoutForPredicate()).on(arg_0 -> this.lambda$nonDeterministicPredicate$16((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.filter("rand() = 0", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))));
    }

    private /* synthetic */ PlanNode lambda$nonDeterministicPredicate$16(Type orderStatusType, PlanBuilder p) {
        p.variable("orderstatus", orderStatusType);
        return p.filter(p.rowExpression("orderstatus = 'O' AND rand() = 0"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"orderstatus", (Type)orderStatusType)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"orderstatus", (Type)orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$nonDeterministicPredicate$15(Type orderStatusType, PlanBuilder p) {
        p.variable("orderstatus", orderStatusType);
        return p.filter(p.rowExpression("orderstatus = 'O' AND rand() = 0"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("orderstatus", orderStatusType)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$ruleWithPushdownableToTableLayoutPredicate$14(Type orderStatusType, PlanBuilder p) {
        p.variable("orderstatus", orderStatusType);
        return p.filter(p.rowExpression("orderstatus = 'O'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"orderstatus", (Type)orderStatusType)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"orderstatus", (Type)orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$ruleWithPushdownableToTableLayoutPredicate$13(Type orderStatusType, PlanBuilder p) {
        p.variable("orderstatus", (Type)VarcharType.createVarcharType((int)1));
        return p.filter(p.rowExpression("orderstatus = 'O'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("orderstatus", orderStatusType)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$replaceWithExistsWhenNoLayoutExist$5(ColumnHandle columnHandle, PlanBuilder p) {
        p.variable("nationkey");
        return p.filter(p.rowExpression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)Expressions.variable((String)"nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)Expressions.variable((String)"nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none()));
    }

    private /* synthetic */ PlanNode lambda$replaceWithExistsWhenNoLayoutExist$4(ColumnHandle columnHandle, PlanBuilder p) {
        p.variable("nationkey", (Type)BigintType.BIGINT);
        return p.filter(p.rowExpression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none()));
    }
}

