/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.NoopSqlFunctionExecutor;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.testing.InMemoryFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionExecutor;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PlanRemoteProjections;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPlanRemoteProjections {
    private static final QualifiedObjectName REMOTE_FOO = QualifiedObjectName.valueOf((CatalogSchemaName)new CatalogSchemaName("unittest", "memory"), (String)"remote_foo");
    private static final RoutineCharacteristics.Language JAVA = new RoutineCharacteristics.Language("java");
    private static final SqlInvokedFunction FUNCTION_REMOTE_FOO_0 = new SqlInvokedFunction(REMOTE_FOO, (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"integer"), "remote_foo()", RoutineCharacteristics.builder().setLanguage(JAVA).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", FunctionVersion.notVersioned());
    private static final SqlInvokedFunction FUNCTION_REMOTE_FOO_1 = new SqlInvokedFunction(REMOTE_FOO, (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "remote_foo(x)", RoutineCharacteristics.builder().setLanguage(JAVA).setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", FunctionVersion.notVersioned());
    private static final SqlInvokedFunction FUNCTION_REMOTE_FOO_2 = new SqlInvokedFunction(REMOTE_FOO, (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer")), (Object)new Parameter("y", TypeSignature.parseTypeSignature((String)"integer"))), TypeSignature.parseTypeSignature((String)"integer"), "remote_foo(x, y)", RoutineCharacteristics.builder().setLanguage(JAVA).setDeterminism(RoutineCharacteristics.Determinism.DETERMINISTIC).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", FunctionVersion.notVersioned());
    private static final SqlInvokedFunction FUNCTION_REMOTE_FOO_3 = new SqlInvokedFunction(REMOTE_FOO, (List)ImmutableList.of((Object)new Parameter("x", TypeSignature.parseTypeSignature((String)"integer")), (Object)new Parameter("y", TypeSignature.parseTypeSignature((String)"integer")), (Object)new Parameter("z", TypeSignature.parseTypeSignature((String)"double"))), TypeSignature.parseTypeSignature((String)"integer"), "remote_foo(x, y, z)", RoutineCharacteristics.builder().setLanguage(JAVA).setNullCallClause(RoutineCharacteristics.NullCallClause.RETURNS_NULL_ON_NULL_INPUT).build(), "", FunctionVersion.notVersioned());
    private RuleTester tester;

    @BeforeClass
    public void setup() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of((Object)"remote_functions_enabled", (Object)"true"));
        FunctionAndTypeManager functionAndTypeManager = this.getFunctionAndTypeManager();
        functionAndTypeManager.addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL, (Object)JAVA, (Object)FunctionImplementationType.THRIFT), (SqlFunctionExecutor)new NoopSqlFunctionExecutor()), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql,java")));
        functionAndTypeManager.createFunction(FUNCTION_REMOTE_FOO_0, true);
        functionAndTypeManager.createFunction(FUNCTION_REMOTE_FOO_1, true);
        functionAndTypeManager.createFunction(FUNCTION_REMOTE_FOO_2, true);
        functionAndTypeManager.createFunction(FUNCTION_REMOTE_FOO_3, true);
    }

    @Test
    void testLocalOnly() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.getMetadata());
        planBuilder.variable("x", (Type)IntegerType.INTEGER);
        planBuilder.variable("y", (Type)IntegerType.INTEGER);
        PlanRemoteProjections rule = new PlanRemoteProjections(this.getFunctionAndTypeManager());
        List rewritten = rule.planRemoteAssignments(Assignments.builder().put(planBuilder.variable("a"), planBuilder.rowExpression("abs(x) + abs(y)")).put(planBuilder.variable("b", (Type)BooleanType.BOOLEAN), planBuilder.rowExpression("x is null and y is null")).build(), new VariableAllocator((Collection)planBuilder.getTypes().allVariables()));
        Assert.assertEquals((int)rewritten.size(), (int)1);
        Assert.assertEquals((int)((PlanRemoteProjections.ProjectionContext)rewritten.get(0)).getProjections().size(), (int)2);
    }

    @Test
    void testRemoteOnly() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.getMetadata());
        PlanRemoteProjections rule = new PlanRemoteProjections(this.getFunctionAndTypeManager());
        List rewritten = rule.planRemoteAssignments(Assignments.builder().put(planBuilder.variable("a"), planBuilder.rowExpression("unittest.memory.remote_foo()")).put(planBuilder.variable("b"), planBuilder.rowExpression("unittest.memory.remote_foo(unittest.memory.remote_foo())")).build(), new VariableAllocator((Collection)planBuilder.getTypes().allVariables()));
        Assert.assertEquals((int)rewritten.size(), (int)2);
        Assert.assertEquals((int)((PlanRemoteProjections.ProjectionContext)rewritten.get(1)).getProjections().size(), (int)2);
    }

    @Test
    void testRemoteAndLocal() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.getMetadata());
        planBuilder.variable("x", (Type)IntegerType.INTEGER);
        planBuilder.variable("y", (Type)IntegerType.INTEGER);
        PlanRemoteProjections rule = new PlanRemoteProjections(this.getFunctionAndTypeManager());
        List rewritten = rule.planRemoteAssignments(Assignments.builder().put(planBuilder.variable("a"), planBuilder.rowExpression("unittest.memory.remote_foo(x, y + unittest.memory.remote_foo(x))")).put(planBuilder.variable("b"), planBuilder.rowExpression("abs(x)")).put(planBuilder.variable("c"), planBuilder.rowExpression("abs(unittest.memory.remote_foo())")).put(planBuilder.variable("d"), planBuilder.rowExpression("unittest.memory.remote_foo(x + y, abs(x))")).build(), new VariableAllocator((Collection)planBuilder.getTypes().allVariables()));
        Assert.assertEquals((int)rewritten.size(), (int)4);
        Assert.assertEquals((int)((PlanRemoteProjections.ProjectionContext)rewritten.get(3)).getProjections().size(), (int)4);
    }

    @Test
    void testSpecialForm() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), this.getMetadata());
        planBuilder.variable("x", (Type)IntegerType.INTEGER);
        planBuilder.variable("y", (Type)IntegerType.INTEGER);
        PlanRemoteProjections rule = new PlanRemoteProjections(this.getFunctionAndTypeManager());
        List rewritten = rule.planRemoteAssignments(Assignments.builder().put(planBuilder.variable("a"), planBuilder.rowExpression("unittest.memory.remote_foo(x, y + unittest.memory.remote_foo(x))")).put(planBuilder.variable("b"), planBuilder.rowExpression("x IS NULL OR y IS NULL")).put(planBuilder.variable("c"), planBuilder.rowExpression("IF(abs(unittest.memory.remote_foo()) > 0, x, y)")).put(planBuilder.variable("d"), planBuilder.rowExpression("unittest.memory.remote_foo(x + y, abs(x))")).put(planBuilder.variable("e"), planBuilder.rowExpression("TRUE OR FALSE")).build(), new VariableAllocator((Collection)planBuilder.getTypes().allVariables()));
        Assert.assertEquals((int)rewritten.size(), (int)4);
        Assert.assertEquals((int)((PlanRemoteProjections.ProjectionContext)rewritten.get(3)).getProjections().size(), (int)5);
    }

    @Test
    void testRemoteFunctionRewrite() {
        this.tester.assertThat((Rule)new PlanRemoteProjections(this.getFunctionAndTypeManager())).on(p -> {
            p.variable("x", (Type)IntegerType.INTEGER);
            p.variable("y", (Type)IntegerType.INTEGER);
            return p.project(Assignments.builder().put(p.variable("a"), p.rowExpression("unittest.memory.remote_foo(x)")).put(p.variable("b"), p.rowExpression("unittest.memory.remote_foo(unittest.memory.remote_foo())")).build(), (PlanNode)p.values(p.variable("x", (Type)IntegerType.INTEGER)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo(unittest_memory_remote_foo)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo(x)"), (Object)"unittest_memory_remote_foo", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo()")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0))))));
    }

    @Test
    void testMixedExpressionRewrite() {
        this.tester.assertThat((Rule)new PlanRemoteProjections(this.getFunctionAndTypeManager())).on(p -> {
            p.variable("x", (Type)IntegerType.INTEGER);
            p.variable("y", (Type)IntegerType.INTEGER);
            return p.project(Assignments.builder().put(p.variable("a"), p.rowExpression("unittest.memory.remote_foo(1, y + unittest.memory.remote_foo(x))")).put(p.variable("b"), p.rowExpression("x IS NULL OR y IS NULL")).put(p.variable("c"), p.rowExpression("abs(unittest.memory.remote_foo()) > 0")).put(p.variable("d"), p.rowExpression("unittest.memory.remote_foo(x + y, abs(1))")).build(), (PlanNode)p.values(p.variable("x", (Type)IntegerType.INTEGER), p.variable("y", (Type)IntegerType.INTEGER)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo(expr, add)"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"c", (Object)PlanMatchPattern.expression("c"), (Object)"d", (Object)PlanMatchPattern.expression("d")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"add", (Object)PlanMatchPattern.expression("y + unittest_memory_remote_foo"), (Object)"expr", (Object)PlanMatchPattern.expression("expr"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"c", (Object)PlanMatchPattern.expression("abs(unittest_memory_remote_foo_7) > 0"), (Object)"d", (Object)PlanMatchPattern.expression("d")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"y", (Object)PlanMatchPattern.expression("y")).put((Object)"expr", (Object)PlanMatchPattern.expression("expr")).put((Object)"unittest_memory_remote_foo", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo(x)")).put((Object)"b", (Object)PlanMatchPattern.expression("b")).put((Object)"unittest_memory_remote_foo_7", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo()")).put((Object)"d", (Object)PlanMatchPattern.expression("unittest.memory.remote_foo(add_10, abs_12)")).build(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"x", (Object)PlanMatchPattern.expression("x")).put((Object)"y", (Object)PlanMatchPattern.expression("y")).put((Object)"expr", (Object)PlanMatchPattern.expression("1")).put((Object)"b", (Object)PlanMatchPattern.expression("x IS NULL OR y is NULL")).put((Object)"add_10", (Object)PlanMatchPattern.expression("x + y")).put((Object)"abs_12", (Object)PlanMatchPattern.expression("abs(1)")).build(), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"y", (Object)1)))))));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp=".*Remote functions are not enabled")
    public void testRemoteFunctionDisabled() {
        RuleTester tester = new RuleTester((List<Plugin>)ImmutableList.of());
        FunctionAndTypeManager functionAndTypeManager = tester.getMetadata().getFunctionAndTypeManager();
        functionAndTypeManager.addFunctionNamespace("unittest", (FunctionNamespaceManager)new InMemoryFunctionNamespaceManager("unittest", new SqlFunctionExecutors((Map)ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL, (Object)JAVA, (Object)FunctionImplementationType.THRIFT), (SqlFunctionExecutor)new NoopSqlFunctionExecutor()), new SqlInvokedFunctionNamespaceManagerConfig().setSupportedFunctionLanguages("sql,java")));
        functionAndTypeManager.createFunction(FUNCTION_REMOTE_FOO_1, true);
        tester.assertThat((Rule)new PlanRemoteProjections(functionAndTypeManager)).on(p -> {
            p.variable("x", (Type)IntegerType.INTEGER);
            return p.project(Assignments.builder().put(p.variable("a"), p.rowExpression("unittest.memory.remote_foo(x)")).build(), (PlanNode)p.values(p.variable("x", (Type)IntegerType.INTEGER)));
        }).matches(PlanMatchPattern.anyTree(new PlanMatchPattern[0]));
    }

    private Metadata getMetadata() {
        return this.tester.getMetadata();
    }

    private FunctionAndTypeManager getFunctionAndTypeManager() {
        return this.getMetadata().getFunctionAndTypeManager();
    }
}

