/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneAggregationSourceColumns
extends BaseRuleTest {
    public TestPruneAggregationSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneAggregationSourceColumns()).on(p -> this.buildAggregation((PlanBuilder)p, (Predicate<VariableReferenceExpression>)Predicates.alwaysTrue())).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("avg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"input"))), (Map<Symbol, Symbol>)ImmutableMap.of((Object)new Symbol("avg"), (Object)new Symbol("mask")), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"input", (Object)PlanMatchPattern.expression("input"), (Object)"key", (Object)PlanMatchPattern.expression("key"), (Object)"keyHash", (Object)PlanMatchPattern.expression("keyHash"), (Object)"mask", (Object)PlanMatchPattern.expression("mask")), PlanMatchPattern.values("input", "key", "keyHash", "mask", "unused"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneAggregationSourceColumns()).on(p -> this.buildAggregation((PlanBuilder)p, variable -> !variable.getName().equals("unused"))).doesNotFire();
    }

    private AggregationNode buildAggregation(PlanBuilder planBuilder, Predicate<VariableReferenceExpression> sourceVariableFilter) {
        VariableReferenceExpression avg = planBuilder.variable("avg");
        VariableReferenceExpression input = planBuilder.variable("input");
        VariableReferenceExpression key = planBuilder.variable("key");
        VariableReferenceExpression keyHash = planBuilder.variable("keyHash");
        VariableReferenceExpression mask = planBuilder.variable("mask");
        VariableReferenceExpression unused = planBuilder.variable("unused");
        List filteredSourceVariables = (List)ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask, (Object)unused).stream().filter(sourceVariableFilter).collect(ImmutableList.toImmutableList());
        return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.singleGroupingSet(key).addAggregation(avg, planBuilder.rowExpression("avg(input)"), Optional.empty(), Optional.empty(), false, Optional.of(mask)).hashVariable(keyHash).source((PlanNode)planBuilder.values(filteredSourceVariables, (List<List<RowExpression>>)ImmutableList.of())));
    }
}

