/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PruneOrderByInAggregation;
import com.facebook.presto.sql.planner.iterative.rule.test.BaseRuleTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneOrderByInAggregation
extends BaseRuleTest {
    private static final FunctionAndTypeManager FUNCTION_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();

    public TestPruneOrderByInAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testBasics() {
        this.tester().assertThat((Rule)new PruneOrderByInAggregation(FUNCTION_MANAGER)).on(this::buildAggregation).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("avg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"input")), Optional.of("array_agg"), PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"input"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("input", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), (Map<Symbol, Symbol>)ImmutableMap.of((Object)new Symbol("avg"), (Object)new Symbol("mask"), (Object)new Symbol("array_agg"), (Object)new Symbol("mask")), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input", "key", "keyHash", "mask")));
    }

    private AggregationNode buildAggregation(PlanBuilder planBuilder) {
        VariableReferenceExpression avg = planBuilder.variable("avg");
        VariableReferenceExpression arrayAgg = planBuilder.variable("array_agg");
        VariableReferenceExpression input = planBuilder.variable("input");
        VariableReferenceExpression key = planBuilder.variable("key");
        VariableReferenceExpression keyHash = planBuilder.variable("keyHash");
        VariableReferenceExpression mask = planBuilder.variable("mask");
        ImmutableList sourceVariables = ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask);
        OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)new Ordering(input, SortOrder.ASC_NULLS_LAST)));
        return planBuilder.aggregation(arg_0 -> TestPruneOrderByInAggregation.lambda$buildAggregation$0(key, avg, planBuilder, orderingScheme, mask, arrayAgg, keyHash, (List)sourceVariables, arg_0));
    }

    private static /* synthetic */ void lambda$buildAggregation$0(VariableReferenceExpression key, VariableReferenceExpression avg, PlanBuilder planBuilder, OrderingScheme orderingScheme, VariableReferenceExpression mask, VariableReferenceExpression arrayAgg, VariableReferenceExpression keyHash, List sourceVariables, PlanBuilder.AggregationBuilder aggregationBuilder) {
        aggregationBuilder.singleGroupingSet(key).addAggregation(avg, planBuilder.rowExpression("avg(input order by input)"), Optional.empty(), Optional.of(orderingScheme), false, Optional.of(mask)).addAggregation(arrayAgg, planBuilder.rowExpression("array_agg(input order by input)"), Optional.empty(), Optional.of(orderingScheme), false, Optional.of(mask)).hashVariable(keyHash).source((PlanNode)planBuilder.values(sourceVariables, (List<List<RowExpression>>)ImmutableList.of()));
    }
}

